<?php

// Repeater list
$service_items = $settings['tj_service_list'] ?? [];

// Animation settings
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay']['size'] ?? '';

// Slider options
$slide_loop           = $settings['slide_loop'] ?? '';
$slide_dot            = $settings['slide_dot'] ?? '';
$slide_autoplay       = $settings['slide_autoplay'] ?? '';
$slide_autoplay_delay = $settings['slide_autoplay_Delay'] ?? 5000;

// Wrapper class with animation
$wrapper_class = 'service-wrapper h10-service-wrapper carouselWrap';
if ($tjAnimation === 'yes' && !empty($tjAnimationName)) {
  $wrapper_class .= ' wow ' . esc_attr($tjAnimationName);
  $this->add_render_attribute('wrapper_attr', 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
}
$this->add_render_attribute('wrapper_attr', 'class', $wrapper_class);

?>

<div <?php echo $this->get_render_attribute_string('wrapper_attr'); ?> data-loop="<?php echo $slide_loop; ?>" data-dot="<?php echo $slide_dot; ?>" data-autoplay="<?php echo $slide_autoplay; ?>" data-delay="<?php echo $slide_autoplay_delay; ?>">

  <div class="swiper h10-service-slider" id="serviceSlider-<?php echo $this->get_id(); ?>">
    <div class="swiper-wrapper">
      <?php foreach ($service_items as $index => $item) :

        $icon          = $item['tj_service_icon'] ?? [];
        $title         = $item['tj_service_title'] ?? '';
        $desc          = $item['tj_service_desc'] ?? '';
        $button        = $item['tj_service_btn'] ?? '';
        $btn_icon      = $item['tj_service_btn_icon'] ?? [];
        $link_type     = $item['tj_service_link_type'] ?? '1';
        $custom_link   = $item['tj_service_link'] ?? [];
        $page_link     = $item['tj_service_page_link'] ?? '';

        // Link setup
        $link_attrs = "service_link_{$index}";

        if ($link_type == '2' && !empty($page_link)) {
          $this->add_render_attribute($link_attrs, 'href', esc_url(get_permalink($page_link)));
          $this->add_render_attribute($link_attrs, 'target', '_self');
          $this->add_render_attribute($link_attrs, 'rel', 'nofollow');
        } elseif (!empty($custom_link['url'])) {
          $this->add_link_attributes($link_attrs, $custom_link);
        }

      ?>
        <div class="swiper-slide">

          <div class="service-item style-4 tj-el-service">

            <h6 class="h10-service-sln"><?php echo str_pad($index + 1, 2, '0', STR_PAD_LEFT), esc_html__('.', 'tjcore'); ?></h6>

            <?php if (!empty($icon['value'])) : ?>
              <div class="service-icon tj-el-icon">
                <?php tj_render_icon($item, 'service_icon', 'tj_service_icon'); ?>
              </div>
            <?php endif; ?>

            <div class="service-content">

              <?php if (!empty($title)) : ?>
                <h4 class="title tj-el-title">
                  <a <?php echo $this->get_render_attribute_string($link_attrs); ?>>
                    <?php echo esc_html($title); ?>
                  </a>
                </h4>
              <?php endif; ?>
              <?php if (!empty($desc)) : ?>
                <p class="desc tj-el-desc"><?php echo esc_html($desc); ?></p>
              <?php endif; ?>

              <?php if (!empty($button)) : ?>
                <a class="text-btn tj-el-btn" <?php echo $this->get_render_attribute_string($link_attrs); ?>>
                  <span class="btn-text"><span><?php echo esc_html($button); ?></span></span>
                  <?php if (!empty($btn_icon['value'])) : ?>
                    <span class="btn-icon"><?php tj_render_icon($item, 'btn_icon', 'tj_service_btn_icon'); ?></span>
                  <?php endif; ?>
                </a>
              <?php endif; ?>

            </div>
          </div>


        </div>
      <?php endforeach; ?>
    </div>

    <?php if (!empty($slide_dot) && $slide_dot === 'yes') : ?>
      <div class="swiper-pagination-area"></div>
    <?php endif; ?>
  </div>
</div>