<?php

// Repeater list
$service_items = $settings['tj_service_list'] ?? [];


?>

<div class="row row-gap-4">
  <?php foreach ($service_items as $index => $item) :

    $icon          = $item['tj_service_icon'] ?? [];
    $title         = $item['tj_service_title'] ?? '';
    $desc          = $item['tj_service_desc'] ?? '';
    $button        = $item['tj_service_btn'] ?? '';
    $btn_icon      = $item['tj_service_btn_icon'] ?? [];
    $link_type     = $item['tj_service_link_type'] ?? '1';
    $custom_link   = $item['tj_service_link'] ?? [];
    $page_link     = $item['tj_service_page_link'] ?? '';

    // Link setup
    $link_attrs = "service_link_{$index}";

    if ($link_type == '2' && !empty($page_link)) {
      $this->add_render_attribute($link_attrs, 'href', esc_url(get_permalink($page_link)));
      $this->add_render_attribute($link_attrs, 'target', '_self');
      $this->add_render_attribute($link_attrs, 'rel', 'nofollow');
    } elseif (!empty($custom_link['url'])) {
      $this->add_link_attributes($link_attrs, $custom_link);
    }

    $tjAnimation       = $item['tj_animation'] ?? '';
    $tjAnimationName   = $item['tj_animation_name'] ?? '';
    $tjAnimationDelay  = $item['tj_animation_delay']['size'] ?? '';
    $service_attr_key  = 'service_item_attr_' . $index;

    $service_class = 'service-item h8-service-item tj-el-service';
    if (!empty($tjAnimation)) {
      $service_class .= ' wow ' . esc_attr($tjAnimationName);
      $this->add_render_attribute($service_attr_key, 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
    }

    $this->add_render_attribute($service_attr_key, 'class', $service_class);


  ?>
    <div class="col-12 col-md-6 col-xl-4">
      <div <?php $this->print_render_attribute_string($service_attr_key); ?>>
        <?php if (!empty($icon['value'])) : ?>
          <div class="service-icon tj-el-icon">
            <?php tj_render_icon($item, 'service_icon', 'tj_service_icon'); ?>
          </div>
        <?php endif; ?>

        <?php if (!empty($title)) : ?>
          <h4 class="title tj-el-title">
            <a <?php echo $this->get_render_attribute_string($link_attrs); ?>>
              <?php echo esc_html($title); ?>
            </a>
          </h4>
        <?php endif; ?>

        <div class="service-content">
          <?php if (!empty($desc)) : ?>
            <div class="desc tj-el-desc">
              <?php echo tj_kses($desc); ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>