<?php

$quote_icon = $settings['tj_quote_icon'] ?? [];
$review_desc = $settings['tj_review_desc'] ?? '';
$reviewer_name = $settings['tj_review_title'] ?? '';
$reviewer_desig = $settings['tj_review_designation'] ?? '';
$review_rating = !empty($settings['tj_review_rating']['size']) ? (float) $settings['tj_review_rating']['size'] : 100;

$tj_rating_show     = $settings['tj_rating_show'] ?? '';
$tjAnimation        = $settings['tj_animation'] ?? '';
$tjAnimationName    = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay']['size'] ?? '';

$itemClass = "testimonial-item tj-el-box";
if ($tjAnimation === 'yes' && !empty($tjAnimationName)) {
  $itemClass .= " wow " . esc_attr($tjAnimationName);
  $this->add_render_attribute('tj_review_attr', 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
}

$this->add_render_attribute('tj_review_attr', 'class', $itemClass);

?>

<div class="h9-testimonial-wrap">
  <div <?php $this->print_render_attribute_string('tj_review_attr'); ?>>
    <?php if (!empty($tj_rating_show)) : ?>
      <div class="star-ratings">
        <div class="fill-ratings tj-el-rating" style="width: <?php echo esc_attr($review_rating); ?>%">
          <span><?php echo esc_html('★★★★★'); ?></span>
        </div>
        <div class="empty-ratings">
          <span><?php echo esc_html('★★★★★'); ?></span>
        </div>
      </div>
    <?php endif; ?>

    <?php if (!empty($review_desc)) : ?>
      <div class="desc tj-el-desc"><?php echo esc_html($review_desc); ?></div>
    <?php endif; ?>

    <?php if (!empty($reviewer_name) || !empty($reviewer_desig)) : ?>
      <div class="testimonial-author">
        <div class="author-inner">
          <div class="author-header">
            <?php if (!empty($reviewer_name)) : ?>
              <h5 class="title tj-el-title"><?php echo esc_html($reviewer_name); ?></h5>
            <?php endif; ?>

            <?php if (!empty($reviewer_desig)) : ?>
              <span class="designation tj-el-desig"><?php echo esc_html($reviewer_desig); ?></span>
            <?php endif; ?>
          </div>
        </div>
      </div>
    <?php endif; ?>
  </div>
</div>