<?php


$tj_rating_number = $settings['tj_rating_number'] ?? '';
$reviewer_name = $settings['tj_review_title'] ?? '';
$review_rating = !empty($settings['tj_review_rating']['size']) ? (float) $settings['tj_review_rating']['size'] : 100;

$tj_rating_show     = $settings['tj_rating_show'] ?? '';
$tjAnimation        = $settings['tj_animation'] ?? '';
$tjAnimationName    = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay']['size'] ?? '';

$itemClass = "rating-box tj-el-box";
if ($tjAnimation === 'yes' && !empty($tjAnimationName)) {
  $itemClass .= " wow " . esc_attr($tjAnimationName);
  $this->add_render_attribute('tj_review_attr', 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
}

$this->add_render_attribute('tj_review_attr', 'class', $itemClass);

?>

<div class="tj-review-box-2">
  <div class="box-area">
    <div <?php echo $this->get_render_attribute_string('tj_review_attr'); ?>>
      <?php if (!empty($tj_rating_number)) : ?>
        <h2 class="title tj-el-desc"><?php echo tj_kses($tj_rating_number); ?></h2>
      <?php endif; ?>
      <?php if (!empty($tj_rating_show)) : ?>
        <div class="rating-area">
          <div class="star-ratings">
            <div class="fill-ratings" style="width: <?php echo esc_attr($review_rating); ?>%">
              <span><?php echo esc_html('★★★★★'); ?></span>
            </div>
            <div class="empty-ratings">
              <span><?php echo esc_html('★★★★★'); ?></span>
            </div>
          </div>
        </div>
      <?php endif; ?>
      <?php if (!empty($reviewer_name)) : ?>
        <span class="rating-text tj-el-title"><?php echo esc_html($reviewer_name); ?></span>
      <?php endif; ?>
    </div>
  </div>
</div>