<?php
// Current Page
$paged = max(1, get_query_var('paged') ? get_query_var('paged') : get_query_var('page'));

// Settings
$posts_per_page = !empty($settings['posts_per_page']) ? $settings['posts_per_page'] : -1;
$orderby        = !empty($settings['orderby']) ? $settings['orderby'] : 'post_date';
$order          = !empty($settings['order']) ? $settings['order'] : 'desc';
$offset_value   = !empty($settings['offset']) ? intval($settings['offset']) : 0;

// Proper offset
$offset = $offset_value + (($paged - 1) * $posts_per_page);

// Include Categories (correct handling)
$category_list_value = !empty($settings['category']) ? $settings['category'] : [];

// Exclude Categories
$exclude_category_list_value = !empty($settings['exclude_category']) ? $settings['exclude_category'] : [];

// Post Include
$pI_ids = !empty($settings['post__in']) ? array_map('intval', $settings['post__in']) : [];

// Post Exclude
$pE_ids = !empty($settings['post__not_in']) ? array_map('intval', $settings['post__not_in']) : [];

// Query args
$args = [
  'post_type'      => 'projects',
  'post_status'    => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby'        => $orderby,
  'order'          => $order,
  'offset'         => $offset,
  'paged'          => $paged,
  'post__in'       => $pI_ids,
  'post__not_in'   => $pE_ids,
];

// Tax Query
$tax_query = [];

if (!empty($exclude_category_list_value)) {
  $tax_query[] = [
    'taxonomy' => 'projects-cat',
    'field'    => 'slug',
    'terms'    => $exclude_category_list_value,
    'operator' => 'NOT IN',
  ];
}

if (!empty($category_list_value)) {
  $tax_query[] = [
    'taxonomy' => 'projects-cat',
    'field'    => 'slug',
    'terms'    => $category_list_value,
    'operator' => 'IN',
  ];
}

if (!empty($tax_query)) {
  $args['tax_query'] = $tax_query;
}

// Query
$query = new WP_Query($args);

// Animation
$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

$projectClass = "project-item tj-el-project";
if (!empty($tjAnimation)) {
  $projectClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-project-arg', 'data-wow-delay', $tjAnimationDelay . "s");
}
$this->add_render_attribute('tj-project-arg', 'class', $projectClass);

?>

<!-- start: Project Area -->
<div class="tj-project-area">
  <div class="row row-gap-4">
    <?php if ($query->have_posts()) : ?>
      <?php while ($query->have_posts()) : $query->the_post();
        $categories = get_the_terms(get_the_ID(), 'projects-cat');
      ?>
        <div class="col-xl-4 col-md-6">
          <div <?php echo $this->get_render_attribute_string('tj-project-arg'); ?>>

            <?php if (has_post_thumbnail()) : ?>
              <div class="project-img">
                <a href="<?php the_permalink(); ?>">
                  <?php the_post_thumbnail('full'); ?>
                </a>
              </div>
            <?php endif; ?>

            <div class="project-content">

              <?php if (!empty($categories)) : ?>
                <span class="categories">
                  <?php
                  $cat_links = [];
                  foreach ($categories as $cat) {
                    $cat_links[] = '<a class="tj-el-cat" href="' . esc_url(get_term_link($cat)) . '">' . esc_html($cat->name) . '</a>';
                  }
                  echo implode(' ', $cat_links);
                  ?>
                </span>
              <?php endif; ?>

              <div class="project-text">
                <h4 class="title tj-el-title">
                  <a href="<?php the_permalink(); ?>">
                    <?php echo wp_trim_words(get_the_title(), $settings['tj_post_title_word'], '...'); ?>
                  </a>
                </h4>

                <?php if (!empty($settings['tj_post_icon']['value'])) : ?>
                  <a class="project-btn tj-el-icon-btn" href="<?php the_permalink(); ?>">
                    <?php tj_render_icon($settings, 'tj_post_icon', 'post_icon'); ?>
                  </a>
                <?php endif; ?>
              </div>

            </div>

          </div>
        </div>
      <?php endwhile;
      wp_reset_postdata(); ?>

    <?php else : ?>
      <p><?php esc_html_e("No projects available", 'tjcore'); ?></p>
    <?php endif; ?>
  </div>

  <?php if (!empty($settings['tj_pagination'])) : ?>
    <div class="tj-pagination d-flex justify-content-center">
      <?php
      echo paginate_links([
        'base'      => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
        'format'    => '?paged=%#%',
        'current'   => $paged,
        'total'     => $query->max_num_pages,
        'prev_text' => '<i class="tji-arrow-left-long"></i>',
        'next_text' => '<i class="tji-arrow-right-long"></i>',
        'type'      => 'list',
        'end_size'  => 2,
        'mid_size'  => 2,
      ]);
      ?>
    </div>
  <?php endif; ?>
</div>
<!-- end: Project Area -->