<?php

// Repeater list
$project_items = $settings['tj_project_list'] ?? [];

$tjSectionSubtitle   = $settings['tj_subtitle'] ?? "";
// animation
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';
if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "sub-title wow $tjSubtitleAnimationName";
  $this->add_render_attribute('subtitle_arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "sub-title";
}
$this->add_render_attribute('subtitle_arg', 'class', $subtitleClass);


$tjSectionTitle   = $settings['tj_title'] ?? "";
$tjSectionTitleTag   = $settings['tj_title_tag'] ?? "";
// animation
$tj_gsap_animation   = $settings['tj_gsap_animation'] ?? '';
$tjGsapAnimationType   = $settings['animation_type'] ?? '';
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';
if (!empty($tjTitleAnimation)) {
  $titleClass = "sec-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} elseif (!empty($tj_gsap_animation) && !empty($tjGsapAnimationType)) {
  $titleClass = "sec-title $tjGsapAnimationType";
} else {
  $titleClass = "sec-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);


// button
$btnText           = $settings['tj_btn_text'] ?? '';
$btnLinkType       = $settings['tj_btn_link_type'] ?? '';
$btnLink           = $settings['tj_btn_link'] ?? [];
$btnPageLink       = $settings['tj_btn_page_link'] ?? '';
$btnIcon           = $settings['tj_btn_icon'] ?? '';
$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

// Initialize button class
$btnClass = 'tj-primary-btn tj-el-btn';

if (!empty($tjAnimation) && !empty($tjAnimationName)) {
  $btnClass .= ' wow ' . esc_attr($tjAnimationName);

  if (!empty($tjAnimationDelay)) {
    $this->add_render_attribute('tj_btn_attr', 'data-wow-delay', esc_attr($tjAnimationDelay . 's'));
  }
}

if ($btnLinkType === '2' && !empty($btnPageLink)) {
  $this->add_render_attribute('tj_btn_attr', 'href', esc_url(get_permalink($btnPageLink)));
  $this->add_render_attribute('tj_btn_attr', 'target', '_self');
  $this->add_render_attribute('tj_btn_attr', 'rel', 'nofollow');
} elseif (!empty($btnLink['url'])) {
  $this->add_link_attributes('tj_btn_attr', $btnLink);
}

$this->add_render_attribute('tj_btn_attr', 'class', esc_attr($btnClass));


?>

<section class="h5-project">
  <div class="tj-scroll-slider tj-el-section section-gap">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <div class="sec-heading-wrap style-3">
            <?php if (!empty($tjSectionSubtitle)) : ?>
              <span <?php echo $this->get_render_attribute_string('subtitle_arg'); ?>>
                <?php if (!empty("yes" == $settings['is_subtitle_icon'] && $settings['tj_subtitle_icon']['value'])) : ?>
                  <?php tj_render_icon($settings, 'subtitle_icon', 'tj_subtitle_icon'); ?>
                <?php endif; ?>
                <?php echo esc_html($tjSectionSubtitle); ?>
              </span>
            <?php endif; ?>
            <div class="heading-wrap-content">
              <?php if (!empty($tjSectionTitle)) : ?>
                <div class="sec-heading style-3">
                  <?php
                  if (!empty($tjSectionTitle)) :
                    printf(
                      '<%1$s %2$s>%3$s</%1$s>',
                      tag_escape($tjSectionTitleTag),
                      $this->get_render_attribute_string('title_args'),
                      tj_kses($tjSectionTitle)
                    );
                  endif;
                  ?>
                </div>
              <?php endif; ?>
              <?php if (!empty($btnText)) : ?>
                <div class="btn-area">
                  <a <?php echo $this->get_render_attribute_string('tj_btn_attr'); ?>>
                    <span class="btn-text"><span><?php echo esc_html($btnText); ?></span></span>
                    <?php if (!empty($btnIcon['value'])) : ?>
                      <span class="btn-icon">
                        <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                      </span>
                    <?php endif; ?>
                  </a>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
      <div class="row ">
        <div class="col-12">
          <div class="project-wrapper h5-project-wrapper">
            <?php foreach ($project_items as $index => $item) :

              $image         = $item['tj_project_image']['url'] ?? '';
              $image_id      = $item['tj_project_image']['id'] ?? '';
              $title         = $item['tj_project_title'] ?? '';
              $desc          = $item['tj_project_desc'] ?? '';
              $category      = $item['tj_project_cat'] ?? '';
              $category_link = $item['tj_project_cat_link'] ?? [];
              $btn_text      = $item['tj_project_btn'] ?? '';
              $btn_icon      = $item['tj_project_btn_icon'] ?? [];
              $link_type     = $item['tj_project_link_type'] ?? '1';
              $custom_link   = $item['tj_project_link'] ?? [];
              $page_link     = $item['tj_project_page_link'] ?? '';

              // link setup
              $link_attrs = "project_link_{$index}";

              if ($link_type == '2' && !empty($page_link)) {
                $this->add_render_attribute($link_attrs, 'href', esc_url(get_permalink($page_link)));
                $this->add_render_attribute($link_attrs, 'target', '_self');
                $this->add_render_attribute($link_attrs, 'rel', 'nofollow');
              } elseif (!empty($custom_link['url'])) {
                $this->add_link_attributes($link_attrs, $custom_link);
              }

              // Animation attributes
              $tjAnimation       = $item['tj_animation'] ?? '';
              $tjAnimationName   = $item['tj_animation_name'] ?? '';
              $tjAnimationDelay  = $item['tj_animation_delay']['size'] ?? '';
              $project_attr_key  = 'project_item_attr_' . $index;

              $project_class = 'project-item h4-project-item  h5-project-item tj-el-project';
              if (!empty($tjAnimation)) {
                $project_class .= ' wow ' . esc_attr($tjAnimationName);
                $this->add_render_attribute($project_attr_key, 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
              }

              $this->add_render_attribute($project_attr_key, 'class', $project_class);

            ?>
              <div class="h5-project-item-wrapper tj-scroll-slider-item">
                <div <?php echo $this->get_render_attribute_string($project_attr_key); ?>>
                  <?php if (!empty($image)) : ?>
                    <div class="project-img">
                      <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr(get_post_meta($image_id, '_wp_attachment_image_alt', true)); ?>">
                    </div>
                  <?php endif; ?>

                  <div class="project-content">
                    <?php if (!empty($category)) : ?>
                      <span class="categories">
                        <?php if (!empty($category_link['url'])) : ?>
                          <a class="tj-el-cat" href="<?php echo esc_url($category_link['url']); ?>"><?php echo tj_kses($category); ?></a>
                        <?php else: ?>
                          <span class="tj-el-cat"><?php echo tj_kses($category); ?></span>
                        <?php endif; ?>
                      </span>
                    <?php endif; ?>
                    <?php if (!empty($title)) : ?>
                      <div class="project-text">
                        <h4 class="title tj-el-title">
                          <a <?php echo $this->get_render_attribute_string($link_attrs); ?>>
                            <?php echo tj_kses($title); ?>
                          </a>
                        </h4>
                      </div>
                    <?php endif; ?>
                    <?php if (!empty($desc)) : ?>
                      <p class="desc tj-el-desc"><?php echo tj_kses($desc); ?></p>
                    <?php endif; ?>
                    <?php if (!empty($btn_text)) : ?>
                      <a class="tj-primary-btn tj-el-btn" <?php echo $this->get_render_attribute_string($link_attrs); ?>>
                        <span class="btn-text"><span><?php echo tj_kses($btn_text); ?></span></span>
                        <?php if (!empty($btn_icon['value'])) : ?>
                          <span class="btn-icon"> <?php tj_render_icon($item, 'btn_icon', 'tj_project_btn_icon'); ?></span>
                        <?php endif; ?>
                      </a>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>