<?php

$tjProjectInfoList = $settings['project_info_list'] ?? [];
$tjSectionTitle = $settings['tj_section_title'] ?? '';

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$class = "tj-sidebar-widget mb-0";
if (!empty($tjAnimation)) {
  $class .= " wow $tjAnimationName";
  $this->add_render_attribute('tj_project_info_args', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_project_info_args', 'class', $class);

?>

<div <?php echo $this->get_render_attribute_string('tj_project_info_args'); ?>>
  <?php if (!empty($tjSectionTitle)): ?>
    <h4 class="widget-title"><?php echo tj_kses($tjSectionTitle); ?></h4>
  <?php endif; ?>
  <?php if (!empty($tjProjectInfoList)): ?>
    <div class="infos-list">
      <?php foreach ($tjProjectInfoList as $item):
        $icon        = $item['tj_item_icon'] ?? [];
        $subtitle = $item['tj_project_info_subtitle'] ?? '';
        $title = $item['tj_project_info_title'] ?? '';
      ?>
        <div class="infos-item">
          <?php if (!empty($icon['value'])) : ?>
            <div class="project-icons"><?php tj_render_icon($item, 'item_icon', 'tj_item_icon'); ?></div>
          <?php endif; ?>
          <div class="project-text">
            <?php if (!empty($subtitle)): ?>
              <span><?php echo esc_html($subtitle); ?></span>
            <?php endif; ?>
            <?php if (!empty($title)): ?>
              <h6 class="title"><?php echo tj_kses($title); ?></h6>
            <?php endif; ?>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>