<?php

$progressList = !empty($settings['tj_progress_list']) ? $settings['tj_progress_list'] : [];

$color = $settings['tj_skillbar_color'] ?? '#1E8A8A';
$basecolor = $settings['tj_skillbar_bg_color'] ?? '#ffffff';

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $progressClass = "h4-progress-list wow $tjAnimationName";
  $this->add_render_attribute('tj-progress-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $progressClass = "h4-progress-list";
}
$this->add_render_attribute('tj-progress-arg', 'class', $progressClass);

?>

<?php if (!empty($progressList)): ?>
  <div <?php echo $this->get_render_attribute_string('tj-progress-arg'); ?>>

    <?php foreach ($progressList as $key => $progress):
      $title = $progress['tj_progress_title'];
      $number = $progress['tj_progress'];
    ?>
      <div class="h4-progress-item">
        <?php if (!empty($number)): ?>
          <div class="progress-circle">
            <input type="text" class="knob" value="0" data-rel="<?php echo esc_attr($number['size']); ?>" data-linecap="0" data-width="120"
              data-height="120" data-bgcolor="<?php echo esc_attr($basecolor); ?>" data-fgcolor="<?php echo esc_attr($color); ?>" data-thickness=".16"
              data-readonly="true" disabled>
          </div>
        <?php endif; ?>
        <?php if (!empty($title)): ?>
          <div class="progress-text">
            <span class="sub-title"><?php echo tj_kses($title); ?></span>
          </div>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>

  </div>
<?php endif; ?>