<?php

$tj_title   = $settings['tj_title'] ?? "";

$progressList = !empty($settings['tj_progress_list']) ? $settings['tj_progress_list'] : [];

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $progressClass = "tj-progress-list wow $tjAnimationName";
  $this->add_render_attribute('tj-progress-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $progressClass = "tj-progress-list";
}
$this->add_render_attribute('tj-progress-arg', 'class', $progressClass);

?>

<?php if (!empty($progressList)): ?>
  <ul <?php echo $this->get_render_attribute_string('tj-progress-arg'); ?>>

    <?php foreach ($progressList as $key => $progress):
      $title = $progress['tj_progress_title'];
      $number = $progress['tj_progress'];
    ?>
      <li>
        <?php if (!empty($title)): ?>
          <h6 class="tj-progress-title"><?php echo tj_kses($title); ?></h6>
        <?php endif; ?>
        <?php if (!empty($number)): ?>
          <div class="tj-progress">
            <span class="tj-progress-percent"><?php echo esc_attr($number['size'] . $number['unit']); ?></span>
            <div class="tj-progress-bar" data-percent="<?php echo esc_attr($number['size']); ?>"></div>
          </div>
        <?php endif; ?>
      </li>
    <?php endforeach; ?>

  </ul>
<?php endif; ?>