<?php
$priceTitle = $settings['price_title'] ?? "";
$priceDescription =  $settings['price_description'] ?? "";
$priceCurrency = $settings['tj_price_currency'] ?? "";
$monthlyPrice = $settings['tj_monthly_price'] ?? "";
$priceMonthPeriod = $settings['tj_month_price_period'] ?? "";
$yearlyPrice = $settings['tj_yearly_price'] ?? "";
$priceYearPeriod = $settings['tj_year_price_period'] ?? "";

$isRecommended = !empty($settings['is_price_box_recommend']) ? "active" : "";

$featureTitle = $settings['tj_feature_title'] ?? "";
$featureList = $settings['tj_feature_list'] ?? "";

if ($priceCurrency === 'custom') {
  $currency = $settings['currency_custom'];
} else {
  $currency = self::get_currency_symbol($priceCurrency);
}

$tjBtnText = !empty($settings['tj_btn_text']) ? $settings['tj_btn_text'] : "";
$tjBtnLinkType = !empty($settings['tj_btn_link_type']) ? $settings['tj_btn_link_type'] : "";
$tjBtnLink = !empty($settings['tj_btn_link']) ? $settings['tj_btn_link'] : "";
$tjBtnPageLink = !empty($settings['tj_btn_page_link']) ? $settings['tj_btn_page_link'] : "";

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj-button-arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj-button-arg', 'target', '_self');
  $this->add_render_attribute('tj-button-arg', 'rel', 'nofollow');
  $this->add_render_attribute('tj-button-arg', 'class', "text-btn");
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj-button-arg', $tjBtnLink);
    $this->add_render_attribute('tj-button-arg', 'class', "text-btn");
  }
}

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$priceBoxClass = "pricing-box h5-pricing-box $isRecommended";
if (!empty($tjAnimation)) {
  $priceBoxClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-price-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj-price-arg', 'class', $priceBoxClass);

?>

<div <?php echo $this->get_render_attribute_string('tj-price-arg'); ?>>
  <div class="pricing-header">
    <?php if (!empty($priceTitle)): ?>
      <h4 class="package-name"><?php echo tj_kses($priceTitle); ?></h4>
    <?php endif; ?>

    <?php if (!empty($monthlyPrice)): ?>
      <div class="package-price">
        <span class="package-currency"><?php echo esc_attr($currency) ?></span>
        <span class="price-number" data-year-price="<?php echo esc_attr($yearlyPrice); ?>" data-month-price="<?php echo esc_attr($monthlyPrice); ?>">
          <?php echo esc_html($monthlyPrice, 'tjcore'); ?>
        </span>
        <span class="package-period period" data-year-period="<?php echo esc_attr($priceYearPeriod); ?>" data-month-period="<?php echo esc_attr($priceMonthPeriod); ?>">
          <?php echo tj_kses($priceMonthPeriod, 'tjcore'); ?>
        </span>
      </div>
    <?php endif; ?>

    <?php if (!empty($priceDescription)): ?>
      <div class="package-desc">
        <p><?php echo tj_kses($priceDescription); ?></p>
      </div>
    <?php endif; ?>
  </div>

  <?php if (!empty($featureList) || !empty($featureTitle)): ?>
    <div class="list-items">
      <?php if (!empty($featureTitle)): ?>
        <h6 class="h5-pricing-list-title"><?php echo tj_kses($featureTitle); ?></h6>
      <?php endif; ?>

      <?php if (!empty($featureList)): ?>
        <ul>
          <?php foreach ($featureList as $item):
            $icon = $item['tj_feature_icon'];
            $text = $item['tj_feature_text'];
            $available = $item['tj_feature_available'] === 'yes' ? 'hide' : 'active';
          ?>
            <li class="<?php echo esc_attr($available); ?>">
              <?php tj_render_icon($item, 'feature_icon', 'tj_feature_icon') ?>
              <?php echo esc_html__($text, 'tjcore'); ?>
            </li>
          <?php endforeach; ?>
        </ul>
      <?php endif; ?>
    </div>
  <?php endif; ?>

  <?php if (!empty($tjBtnText)): ?>
    <div class="pricing-btn">
      <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
        <span class="btn-text"><span><?php echo esc_html__($tjBtnText, 'tjcore'); ?></span></span>
        <?php if (!empty($settings['tj_btn_icon']['value'])): ?>
          <span class="btn-icon"> <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?></span>
        <?php endif; ?>
      </a>
    </div>
  <?php endif; ?>
</div>