<?php
$marqueeList = $settings['tj_marquee_list'] ?? [];
$marqueeSlide  = $settings['marquee_slide'] ?? "";

$is_rtl = is_rtl() ? 'rtl' : 'ltr';

?>

<?php if (!empty($marqueeList)) : ?>

  <div class="marquee-wrapper">
    <div class="swiper marquee-slider" dir="<?php echo esc_attr($is_rtl); ?>" id="marquee-<?php echo $this->get_id(); ?>">
      <div class="swiper-wrapper">
        <?php foreach ($marqueeList as $index => $item) :

          $title         = $item['tj_marquee_title'] ?? '';
          $image         = $item['tj_marquee_image']['url'] ?? '';
          $image_id      = $item['tj_marquee_image']['id'] ?? '';

        ?>
          <div class="swiper-slide marquee-item">
            <?php if (!empty($title)): ?>
              <h4 class="marquee-text"><?php echo tj_kses($title); ?></h4>
            <?php endif; ?>
            <?php if (!empty($image)) : ?>
              <div class="marquee-img">
                <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr(get_post_meta($image_id, '_wp_attachment_image_alt', true)); ?>">
              </div>
            <?php endif; ?>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>

<?php endif; ?>