<?php

$lists          = $settings['tj_item_list'] ?? [];
$tjAnimation    = $settings['tj_animation'] ?? '';
$tjAnimationName = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay']['size'] ?? '';

$listClass = 'footer-contact el-list';
if (!empty($tjAnimation)) {
    $listClass .= ' wow ' . esc_attr($tjAnimationName);
    $this->add_render_attribute('tj_list_attr', 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
}
$this->add_render_attribute('tj_list_attr', 'class', $listClass);
?>

<div <?php echo $this->get_render_attribute_string('tj_list_attr'); ?>>
    <?php if (!empty($lists)) : ?>
        <ul>
            <?php foreach ($lists as $index => $item) :

                $icon        = $item['tj_item_icon'] ?? [];
                $menu_item   = $item['tj_item_text'] ?? '';
                $link_type   = $item['tj_item_link_type'] ?? '1';
                $custom_link = $item['tj_item_link'] ?? '';
                $page_link   = $item['tj_item_page_link'] ?? '';

                // Link setup
                $link_attrs = "tj_item_arg_{$index}";
                $has_link = false;

                if ($link_type == '2' && !empty($page_link)) {
                    $this->add_render_attribute($link_attrs, 'href', esc_url(get_permalink($page_link)));
                    $this->add_render_attribute($link_attrs, 'target', '_self');
                    $this->add_render_attribute($link_attrs, 'rel', 'nofollow');
                    $has_link = true;
                } elseif (!empty($custom_link['url'])) {
                    $this->add_link_attributes($link_attrs, $custom_link);
                    $has_link = true;
                }

            ?>
                <li>
                    <?php if ($has_link) : ?>
                        <a <?php echo $this->get_render_attribute_string($link_attrs); ?>>
                        <?php endif; ?>

                        <?php if (!empty($icon['value'])) : ?>
                            <span class="icon"><?php tj_render_icon($item, 'item_icon', 'tj_item_icon'); ?></span>
                        <?php endif; ?>

                        <?php if (!empty($menu_item)) : ?>
                            <span class="text"><?php echo tj_kses($menu_item, 'tjcore'); ?></span>
                        <?php endif; ?>

                        <?php if ($has_link) : ?>
                        </a>
                    <?php endif; ?>
                </li>
            <?php endforeach; ?>

        </ul>
    <?php endif; ?>
</div>