<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

// include_categories
$category_list = '';
if (!empty($settings['category'])) {
  $category_list = implode(", ", $settings['category']);
}
$category_list_value = explode(" ", $category_list);

// exclude_categories
$exclude_categories = '';
if (!empty($settings['exclude_category'])) {
  $exclude_categories = implode(", ", $settings['exclude_category']);
}
$exclude_category_list_value = explode(" ", $exclude_categories);

// include_posts
$post__in = '';
if (!empty($settings['post__in'])) {
  $post__not_in = $settings['post__in'];
  $args['post__in'] = $post__in;
}

// exclude_posts
$post__not_in = '';
if (!empty($settings['post__not_in'])) {
  $post__not_in = $settings['post__not_in'];
  $args['post__not_in'] = $post__not_in;
}

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';
$ignore_sticky_posts = (!empty($settings['ignore_sticky_posts']) && 'yes' == $settings['ignore_sticky_posts']) ? true : false;

// offset
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// Posts Include array
$pI_ids = [];
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// Posts Exclude array
$pE_ids = [];
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}

// args
$args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
  'ignore_sticky_posts' => $ignore_sticky_posts
);

// exclude_categories
if (!empty($settings['exclude_category'])) {

  // Exclude the correct cats from tax_query
  $args['tax_query'] = array(
    array(
      'taxonomy'    => 'category',
      'field'         => 'slug',
      'terms'        => $exclude_category_list_value,
      'operator'    => 'NOT IN'
    )
  );

  // Include the correct cats in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query']['relation'] = 'AND';
    $args['tax_query'][] = array(
      'taxonomy'    => 'category',
      'field'        => 'slug',
      'terms'        => $category_list_value,
      'operator'    => 'IN'
    );
  }
} else {
  // Include the cats from $cat_slugs in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query'][] = [
      'taxonomy' => 'category',
      'field' => 'slug',
      'terms' => $category_list_value,
    ];
  }
}

// The Query
$query = new \WP_Query($args);

// animation
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay']['size'] ?? '';

$wrapClass = "blog-item";

if (!empty($tjAnimation) && !empty($tjAnimationName)) {
  $wrapClass .= " wow " . esc_attr($tjAnimationName);

  if (!empty($tjAnimationDelay)) {
    $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', esc_attr($tjAnimationDelay . "s"));
  }
}

$this->add_render_attribute('tj_wrap_arg', 'class', esc_attr($wrapClass));


?>

<div class="tj-latest-blog">
  <?php if ($query->have_posts()) : ?>
    <div class="row row-gap-4 h6-blog-wrapper">
      <?php
      $n = 0;
      while ($query->have_posts()) :
        $n++;
        $query->the_post();
        $categories = get_the_terms(get_the_ID(), 'category');
      ?>
        <div class="col-xl-<?php echo esc_attr($desktop_column); ?> col-lg-<?php echo esc_attr($laptop_column); ?> col-md-<?php echo esc_attr($tablet_column); ?> col-sm-<?php echo esc_attr($mobile_column); ?>  col-<?php echo esc_attr($ex_mobile_column); ?>">
          <div <?php $this->print_render_attribute_string('tj_wrap_arg'); ?>>
            <?php if (has_post_thumbnail()) : ?>
              <div class="blog-thumb">
                <a href="<?php the_permalink(get_the_ID()); ?>"><?php the_post_thumbnail('full'); ?></a>
                <?php if (!empty($settings['tj_post_date'])) : ?>
                  <div class="blog-date">
                    <span class="date"><?php echo get_the_date('d', get_the_ID()); ?></span>
                    <span class="month"><?php echo get_the_date('M', get_the_ID()); ?></span>
                  </div>
                <?php endif; ?>
              </div>
            <?php endif; ?>

            <div class="blog-content">
              <?php if (!empty($settings['tj_post_author']) || !empty($settings['tj_post_category'])) : ?>
                <div class="blog-meta">
                  <?php if (!empty($settings['tj_post_category']) && (!empty($categories[0]->name))): ?>
                    <span class="categories"><a href="<?php echo esc_url(get_category_link($categories[0]->term_id)); ?>">
                        <?php echo esc_html($categories[0]->name); ?></a></span>
                  <?php endif; ?>
                  <?php if (!empty($settings['tj_post_author'])) : ?>
                    <span><?php printf('%s <a href="%s">%s</a>', esc_html__('By', 'tjcore'), esc_url(get_author_posts_url(get_the_author_meta('ID'))), get_the_author()); ?></span>
                  <?php endif; ?>
                </div>
              <?php endif; ?>

              <h4 class="title">
                <a href="<?php the_permalink(get_the_ID()); ?>">
                  <?php echo wp_trim_words(get_the_title(get_the_ID()), $settings['tj_post_title_word'], '...'); ?>
                </a>
              </h4>

              <?php if ("yes" == $settings['tj_post_content']) :
                $tj_post_content_limit = (!empty($settings['tj_post_content_limit'])) ? $settings['tj_post_content_limit'] : '';
              ?>
                <div class="desc"><?php echo wp_trim_words(get_the_content(get_the_ID()), $tj_post_content_limit, '...'); ?></div>
              <?php endif; ?>

              <?php if (!empty($settings['tj_btn'])) : ?>
                <a class="text-btn" href="<?php the_permalink(get_the_ID()); ?>">
                  <span class="btn-text"><span><?php echo esc_html__($settings['tj_btn'], 'tjcore'); ?></span></span>
                  <span class="btn-icon"><?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?></span>
                </a>
              <?php endif; ?>
            </div>
          </div>
        </div>
      <?php endwhile;
      wp_reset_query(); ?>
    </div>
  <?php endif; ?>
</div>