<?php
$icon         = $settings['tj_info_icon'] ?? [];
$info_title   = $settings['tj_info_title'] ?? '';
$link         = $settings['tj_info_link']['url'] ?? '';
$target       = $settings['tj_info_link']['is_external'] ? ' target="_blank"' : '';
$nofollow     = $settings['tj_info_link']['nofollow'] ? ' rel="nofollow"' : '';

$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

$animation_class = '';
$animation_attr  = '';

if ($tjAnimation === 'yes') {
  $animation_class = 'wow ' . esc_attr($tjAnimationName);
  $animation_attr  = ' data-wow-delay="' . esc_attr($tjAnimationDelay) . 's"';
}
?>

<div class="h7-faq tj-el-box <?php echo esc_attr($animation_class); ?>" <?php echo $animation_attr; ?>>
  <a class="number" href="<?php echo esc_url($link); ?>" <?php echo $target . $nofollow; ?>>
    <?php if (!empty($icon['value'])) : ?>
      <span class="call-icon tj-el-icon">
        <?php \Elementor\Icons_Manager::render_icon($icon, ['aria-hidden' => 'true']); ?>
      </span>
    <?php endif; ?>
    <?php if (!empty($info_title)) : ?>
      <span class="tj-el-phone"><?php echo tj_kses($info_title); ?></span>
    <?php endif; ?>
  </a>
</div>