<?php
$title        = $settings['tj_title'] ?? '';
$icon         = $settings['tj_info_icon'] ?? [];
$info_title   = $settings['tj_info_title'] ?? '';
$link         = $settings['tj_info_link']['url'] ?? '';
$target       = $settings['tj_info_link']['is_external'] ? ' target="_blank"' : '';
$nofollow     = $settings['tj_info_link']['nofollow'] ? ' rel="nofollow"' : '';

$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

$animation_class = '';
$animation_attr  = '';

if ($tjAnimation === 'yes') {
  $animation_class = 'wow ' . esc_attr($tjAnimationName);
  $animation_attr  = ' data-wow-delay="' . esc_attr($tjAnimationDelay) . 's"';
}
?>

<div class="box-area style-4 tj-el-boxwrap">
  <div class="call-box tj-el-box <?php echo esc_attr($animation_class); ?>" <?php echo $animation_attr; ?>>

    <?php if (!empty($title)) : ?>
      <h4 class="title tj-el-title"><?php echo tj_kses($title); ?></h4>
    <?php endif; ?>

    <?php if (!empty($icon['value'])) : ?>
      <span class="call-icon tj-el-icon">
        <?php \Elementor\Icons_Manager::render_icon($icon, ['aria-hidden' => 'true']); ?>
      </span>
    <?php endif; ?>

    <?php if (!empty($info_title)) : ?>
      <?php if (!empty($link)) : ?>
        <a class="number tj-el-phone" href="<?php echo esc_url($link); ?>" <?php echo $target . $nofollow; ?>>
          <span><?php echo tj_kses($info_title); ?></span>
        </a>
      <?php else : ?>
        <span class="number tj-el-phone"><?php echo tj_kses($info_title); ?></span>
      <?php endif; ?>
    <?php endif; ?>

  </div>
</div>