<?php


$image_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src($settings['image']['id'], 'image_size', $settings);
if (empty($image_url)) {
  $image_url = \Elementor\Utils::get_placeholder_image_src();
}


$this->add_render_attribute('title', 'class', 'customers-text tj-el-title');
$title_html = sprintf('<%1$s %2$s>%3$s</%1$s>', $title_tag, $this->get_render_attribute_string('title'), $title);
if (!empty($settings['link']['url'])) {
  $this->add_link_attributes('link', $settings['link']);
  $title_html = sprintf('<%1$s %2$s><a ' . $this->get_render_attribute_string('link') . '>%3$s</a></%1$s>', $title_tag, $this->get_render_attribute_string('title'), $title);
}


$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

$animation_class = '';
$animation_attr  = '';

if ($tjAnimation === 'yes') {
  $animation_class = 'wow ' . esc_attr($tjAnimationName);
  $animation_attr  = ' data-wow-delay="' . esc_attr($tjAnimationDelay) . 's"';
}

?>

<div class="h6-about-img tj-el-imagebox <?php echo esc_attr($animation_class); ?>" <?php echo $animation_attr; ?>>
  <?php if (!empty($settings['image']['url'])) : ?>
    <div class="about-img tj-el-image">
      <img src="<?php echo esc_attr($image_url); ?>" alt="<?php echo esc_attr(get_post_meta($settings['image']['id'], '_wp_attachment_image_alt', true)); ?>">
    </div>
  <?php endif; ?>
  <?php if (!empty($title) || !empty($desc)) : ?>
    <div class="box-area h6-about-box  ">
      <div class="customers-box wow fadeInUp" data-wow-delay="1s">
        <?php if (!empty($desc)) : ?>
          <div class="customers tj-el-desc">
            <?php echo wp_kses_post($desc); ?>
          </div>
        <?php endif; ?>
        <?php if (!empty($title)) {
          echo $title_html;
        } ?>
      </div>
    </div>
  <?php endif; ?>
</div>