<?php

$headerAbsolute = ('yes' == $settings['is_header_absolute']) ? "header-absolute" : "";
$headerSticky = !empty($settings['header_sticky_direction'] && $settings['is_header_sticky']) ? $settings['header_sticky_direction'] : '';

$headerLogo = $settings['tj_logo'];
$stikcyLogo = $settings['tj_sticky_logo'];
$navMenu   = $settings['tj_nav_menu'];

// button
$headerButton   = $settings['show_header_btn'];
$btnText   = $settings['tj_btn_text'];
$btnLinkType   =  $settings['tj_btn_link_type'];
$btnLink   =  $settings['tj_btn_link'];
$btnPageLink   = $settings['tj_btn_page_link'];

if ('2' == $btnLinkType) {
  $this->add_render_attribute('tj_btn_arg', 'href', get_permalink($btnPageLink));
  $this->add_render_attribute('tj_btn_arg', 'target', '_self');
} else {
  if (!empty($btnLink['url'])) {
    $this->add_link_attributes('tj_btn_arg', $btnLink);
  }
}
// search
$headerSearch   = $settings['show_header_search'];
// sidebar
$headerSidebar   = $settings['show_header_sidebar'];

?>

<!-- start: Header Area -->
<header class="header-area header-2 h7-header section-gap-x <?php printf("%s", esc_attr($headerAbsolute)); ?>">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <div class="header-wrapper">

          <?php if (!empty($headerLogo['url'])) : ?>
            <!-- logo -->
            <div class="site_logo">
              <a class="logo" href="<?php echo esc_url(home_url('/')); ?>">
                <img src="<?php echo esc_url($headerLogo['url']); ?>" alt="<?php echo esc_attr(get_post_meta($headerLogo['id'], '_wp_attachment_image_alt', true)); ?>" />
              </a>
            </div>
          <?php endif; ?>

          <?php if (!empty($navMenu)) : ?>
            <!-- navigation -->
            <div class="menu-area d-none d-lg-inline-flex align-items-center">
              <nav id="mobile-menu" class="mainmenu">
                <?php echo $this->render_tj_nav_menu($settings['tj_nav_menu'], true); ?>
              </nav>
            </div>
          <?php endif; ?>

          <?php if (!empty($headerButton) || !empty($headerSearch) || !empty($headerSidebar)) : ?>
            <div class="header-right-item d-none d-lg-inline-flex">
              <?php if (!empty($headerSearch)) : ?>
                <div class="header-search">
                  <button class="search">
                    <?php tj_render_icon($settings, "search_icon", "tj_search_icon"); ?>
                  </button>
                  <button type="button" class="search_close_btn">
                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M17 1L1 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                        stroke-linejoin="round" />
                      <path d="M1 1L17 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                        stroke-linejoin="round" />
                    </svg>
                  </button>
                </div>
              <?php endif; ?>

              <?php if (!empty($headerButton)) : ?>
                <div class="header-button">
                  <a class="tj-primary-btn" <?php echo $this->get_render_attribute_string('tj_btn_arg'); ?>>
                    <span class="btn-text"><span><?php echo tj_kses($btnText); ?></span></span>
                    <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
                      <span class="btn-icon"><?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?></span>
                    <?php endif; ?>
                  </a>
                </div>
              <?php endif; ?>
              <?php if (!empty($headerSidebar)) : ?>
                <div class="menu_bar menu_offcanvas d-none d-lg-inline-flex">
                  <span></span>
                  <span></span>
                  <span></span>
                </div>
              <?php endif; ?>
            </div>
          <?php endif; ?>
          <!-- menu bar -->
          <div class="menu_bar mobile_menu_bar d-lg-none">
            <span></span>
            <span></span>
            <span></span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php if (!empty($headerSearch)) : ?>
    <!-- Search Popup -->
    <div class="search_popup">
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-8">
            <div class="tj_search_wrapper">
              <div class="search_form">
                <form method="get" action="<?php echo esc_url(home_url('/')); ?>">
                  <div class="search_input">
                    <div class="search-box">
                      <input class="search-form-input" type="text" value="<?php echo esc_attr(get_search_query()); ?>" placeholder="<?php echo esc_attr__('Type your words here..', 'tjcore'); ?>" required>
                      <button type="submit">
                        <?php tj_render_icon($settings, "search_icon", "tj_search_icon"); ?>
                      </button>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>
</header>

<header class="header-area header-2 h7-header header-duplicate section-gap-x <?php printf("%s", esc_attr($headerSticky)); ?>">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <div class="header-wrapper">

          <?php if (!empty($stikcyLogo['url'])) : ?>
            <!-- logo -->
            <div class="site_logo">
              <a class="logo" href="<?php echo esc_url(home_url('/')); ?>">
                <img src="<?php echo esc_url($stikcyLogo['url']); ?>" alt="<?php echo esc_attr(get_post_meta($stikcyLogo['id'], '_wp_attachment_image_alt', true)); ?>" />
              </a>
            </div>
          <?php endif; ?>

          <?php if (!empty($navMenu)) : ?>
            <!-- navigation -->
            <div class="menu-area d-none d-lg-inline-flex align-items-center">
              <nav class="mainmenu">
                <?php echo $this->render_tj_nav_menu($settings['tj_nav_menu'], false); ?>
              </nav>
            </div>
          <?php endif; ?>

          <?php if (!empty($headerButton) || !empty($headerSearch) || !empty($headerSidebar)) : ?>
            <div class="header-right-item d-none d-lg-inline-flex">
              <?php if (!empty($headerSearch)) : ?>
                <div class="header-search">
                  <button class="search">
                    <?php tj_render_icon($settings, "search_icon", "tj_search_icon"); ?>
                  </button>
                  <button type="button" class="search_close_btn">
                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M17 1L1 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                        stroke-linejoin="round" />
                      <path d="M1 1L17 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                        stroke-linejoin="round" />
                    </svg>
                  </button>
                </div>
              <?php endif; ?>

              <?php if (!empty($headerButton)) : ?>
                <div class="header-button">
                  <a class="tj-primary-btn" <?php echo $this->get_render_attribute_string('tj_btn_arg'); ?>>
                    <span class="btn-text"><span><?php echo tj_kses($btnText); ?></span></span>
                    <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
                      <span class="btn-icon"><?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?></span>
                    <?php endif; ?>
                  </a>
                </div>
              <?php endif; ?>
              <?php if (!empty($headerSidebar)) : ?>
                <div class="menu_bar menu_offcanvas d-none d-lg-inline-flex">
                  <span></span>
                  <span></span>
                  <span></span>
                </div>
              <?php endif; ?>
            </div>
          <?php endif; ?>
          <!-- menu bar -->
          <div class="menu_bar mobile_menu_bar d-lg-none">
            <span></span>
            <span></span>
            <span></span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php if (!empty($headerSearch)) : ?>
    <!-- Search Popup -->
    <div class="search_popup">
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-8">
            <div class="tj_search_wrapper">
              <div class="search_form">
                <form method="get" action="<?php echo esc_url(home_url('/')); ?>">
                  <div class="search_input">
                    <div class="search-box">
                      <input class="search-form-input" type="text" value="<?php echo esc_attr(get_search_query()); ?>" placeholder="<?php echo esc_attr__('Type your words here..', 'tjcore'); ?>" required>
                      <button type="submit">
                        <?php tj_render_icon($settings, "search_icon", "tj_search_icon"); ?>
                      </button>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>
</header>
<!-- end: Header Area -->
<?php if (!empty($headerSearch)): ?>
  <!-- start: Search Popup -->
  <div class="search-popup-overlay"></div>
  <!-- end: Search Popup -->
<?php endif; ?>

<?php
$mobileLogo = $settings['tj_mobile_logo'];
$mobileDesc = $settings['tj_mobile_desc'];
$showMobileSearch = $settings['show_mobile_search'];
$mobilesearchTitle = $settings['tj_mobile_search_title'];
$mobileSearchPlaceholder = $settings['tj_mobile_search_placeholder'];
$showMobileContact = $settings['is_mobile_contact'];
$mobileContactTitle = $settings['mobile_contact_title'];
$mobileContactList = $settings['mobile_contact_list'];
$showMobileSocials = $settings['is_mobile_socials'];
$mobileSocialsTitle = $settings['mobile_socials_title'];
$mobileSocialsList = $settings['mobile_socials_list'];
?>
<!-- start: Offcanvas Menu -->
<div class="tj-offcanvas-area d-none d-lg-block">
  <div class="hamburger_bg"></div>
  <div class="hamburger_wrapper">
    <div class="hamburger_inner">
      <div class="hamburger_top d-flex align-items-center justify-content-between">
        <?php if (!empty($mobileLogo['url'])): ?>
          <div class="hamburger_logo">
            <a class="mobile_logo logo" href="<?php echo esc_url(home_url('/')); ?>">
              <img src="<?php echo esc_url($mobileLogo['url']); ?>" alt="<?php echo esc_attr(get_post_meta($mobileLogo['id'], '_wp_attachment_image_alt', true)); ?>" />
            </a>
          </div>
        <?php endif; ?>
        <?php if (!empty($settings['tj_mobile_close']['value'])) : ?>
          <div class="hamburger_close">
            <button class="hamburger_close_btn">
              <?php tj_render_icon($settings, "mobile_close", "tj_mobile_close"); ?>
            </button>
          </div>
        <?php endif; ?>
      </div>
      <?php if (!empty($mobileDesc)): ?>
        <div class="offcanvas-text">
          <p><?php echo tj_kses($mobileDesc); ?></p>
        </div>
      <?php endif; ?>

      <?php if (!empty($showMobileSearch)): ?>
        <div class="hamburger-search-area">
          <?php if (!empty($mobilesearchTitle)): ?>
            <h5 class="hamburger-title"><?php echo tj_kses($mobilesearchTitle); ?></h5>
          <?php endif; ?>
          <div class="hamburger_search">
            <form method="get" action="<?php echo esc_url(home_url('/')); ?>">
              <button type="submit"><?php tj_render_icon($settings, "mobile_search_icon", "tj_mobile_search_icon"); ?></button>
              <input type="search" autocomplete="off" name="s" value="<?php echo esc_attr(get_search_query()); ?>" placeholder="<?php echo esc_attr__($mobileSearchPlaceholder, 'tjcore'); ?>" required />
            </form>
          </div>
        </div>
      <?php endif; ?>

      <?php if (!empty($showMobileContact)): ?>
        <div class="hamburger-infos">
          <?php if (!empty($mobileContactTitle)): ?>
            <h5 class="hamburger-title"><?php echo esc_html($mobileContactTitle); ?></h5>
          <?php endif; ?>
          <div class="contact-info">
            <?php if (!empty($mobileContactList)):
              foreach ($mobileContactList as $contact):

                $link = !empty($contact['mobile_contact_link']['url']) ? $contact['mobile_contact_link']['url'] : '';
                $target = !empty($contact['mobile_contact_link']['is_external']) ? '_blank' : '';
                $rel = !empty($contact['mobile_contact_link']['nofollow']) ? 'nofollow' : '';
            ?>
                <div class="contact-item">
                  <?php if (!empty($contact['mobile_contact_label'])): ?>
                    <span class="subtitle"><?php echo esc_html($contact['mobile_contact_label']); ?></span>
                  <?php endif; ?>

                  <?php if (!empty($link)) :
                    $href = 'href=' . $link . '';
                    if (!empty($target)) :
                      $target = 'target=' . $target . '';
                    endif;
                    if (!empty($rel)) :
                      $rel = 'rel=' . $rel . '';
                    endif; ?>
                    <a class="contact-link" <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                      <?php echo esc_html($contact['mobile_contact_text']); ?>
                    </a>
                  <?php else : ?>
                    <span class="contact-link"><?php echo esc_html($contact['mobile_contact_text']); ?></span>
                  <?php endif; ?>
                </div>
            <?php endforeach;
            endif; ?>
          </div>
        </div>
      <?php endif; ?>
    </div>
    <?php if (!empty($showMobileSocials)): ?>
      <div class="hamburger-socials">
        <?php if (!empty($mobileSocialsTitle)): ?>
          <h5 class="hamburger-title"><?php echo esc_html($mobileSocialsTitle); ?></h5>
        <?php endif; ?>
        <?php if (!empty($mobileSocialsList)): ?>
          <div class="social-links style-3">
            <ul>
              <?php foreach ($mobileSocialsList as $social):
                $link = !empty($social['mobile_social_link']['url']) ? $social['mobile_social_link']['url'] : '';
                $target = !empty($social['mobile_social_link']['is_external']) ? '_blank' : '';
                $rel = !empty($social['mobile_social_link']['nofollow']) ? 'nofollow' : '';
              ?>
                <li>
                  <?php if (!empty($link)) :
                    $href = 'href=' . $link . '';
                    if (!empty($target)) :
                      $target = 'target=' . $target . '';
                    endif;
                    if (!empty($rel)) :
                      $rel = 'rel=' . $rel . '';
                    endif;
                  ?>
                    <a <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                      <?php tj_render_icon($social, 'mobile_social_icon', 'tj_mobile_social_icon'); ?>
                    </a>
                  <?php else :
                    tj_render_icon($social, 'mobile_social_icon', 'tj_mobile_social_icon');
                  endif;
                  ?>
                </li>
              <?php endforeach; ?>
            </ul>
          </div>
        <?php endif; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
<!-- end: Offcanvas Menu -->

<!-- start: Hamburger Menu -->
<div class="body-overlay"></div>
<div class="hamburger-area d-lg-none">
  <div class="hamburger_bg"></div>
  <div class="hamburger_wrapper">
    <div class="hamburger_inner">
      <div class="hamburger_top d-flex align-items-center justify-content-between">
        <?php if (!empty($mobileLogo['url'])): ?>
          <div class="hamburger_logo">
            <a class="mobile_logo logo" href="<?php echo esc_url(home_url('/')); ?>">
              <img src="<?php echo esc_url($mobileLogo['url']); ?>" alt="<?php echo esc_attr(get_post_meta($mobileLogo['id'], '_wp_attachment_image_alt', true)); ?>" />
            </a>
          </div>
        <?php endif; ?>
        <?php if (!empty($settings['tj_mobile_close']['value'])) : ?>
          <div class="hamburger_close">
            <button class="hamburger_close_btn">
              <?php tj_render_icon($settings, "mobile_close", "tj_mobile_close"); ?>
            </button>
          </div>
        <?php endif; ?>
      </div>
      <!-- mobile menu -->
      <div class="hamburger_menu">
        <div class="mobile_menu"></div>
      </div>

      <?php if (!empty($showMobileContact)): ?>
        <div class="hamburger-infos">
          <?php if (!empty($mobileContactTitle)): ?>
            <h5 class="hamburger-title"><?php echo esc_html($mobileContactTitle); ?></h5>
          <?php endif; ?>
          <div class="contact-info">
            <?php if (!empty($mobileContactList)):
              foreach ($mobileContactList as $contact):

                $link = !empty($contact['mobile_contact_link']['url']) ? $contact['mobile_contact_link']['url'] : '';
                $target = !empty($contact['mobile_contact_link']['is_external']) ? '_blank' : '';
                $rel = !empty($contact['mobile_contact_link']['nofollow']) ? 'nofollow' : '';
            ?>
                <div class="contact-item">
                  <?php if (!empty($contact['mobile_contact_label'])): ?>
                    <span class="subtitle"><?php echo esc_html($contact['mobile_contact_label']); ?></span>
                  <?php endif; ?>

                  <?php if (!empty($link)) :
                    $href = 'href=' . $link . '';
                    if (!empty($target)) :
                      $target = 'target=' . $target . '';
                    endif;
                    if (!empty($rel)) :
                      $rel = 'rel=' . $rel . '';
                    endif; ?>
                    <a class="contact-link" <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                      <?php echo esc_html($contact['mobile_contact_text']); ?>
                    </a>
                  <?php else : ?>
                    <span class="contact-link"><?php echo esc_html($contact['mobile_contact_text']); ?></span>
                  <?php endif; ?>
                </div>
            <?php endforeach;
            endif; ?>
          </div>
        </div>
      <?php endif; ?>
    </div>
    <?php if (!empty($showMobileSocials)): ?>
      <div class="hamburger-socials">
        <?php if (!empty($mobileSocialsTitle)): ?>
          <h5 class="hamburger-title"><?php echo esc_html($mobileSocialsTitle); ?></h5>
        <?php endif; ?>
        <?php if (!empty($mobileSocialsList)): ?>
          <div class="social-links style-3">
            <ul>
              <?php foreach ($mobileSocialsList as $social):
                $link = !empty($social['mobile_social_link']['url']) ? $social['mobile_social_link']['url'] : '';
                $target = !empty($social['mobile_social_link']['is_external']) ? '_blank' : '';
                $rel = !empty($social['mobile_social_link']['nofollow']) ? 'nofollow' : '';
              ?>
                <li>
                  <?php if (!empty($link)) :
                    $href = 'href=' . $link . '';
                    if (!empty($target)) :
                      $target = 'target=' . $target . '';
                    endif;
                    if (!empty($rel)) :
                      $rel = 'rel=' . $rel . '';
                    endif;
                  ?>
                    <a <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                      <?php tj_render_icon($social, 'mobile_social_icon', 'tj_mobile_social_icon'); ?>
                    </a>
                  <?php else :
                    tj_render_icon($social, 'mobile_social_icon', 'tj_mobile_social_icon');
                  endif;
                  ?>
                </li>
              <?php endforeach; ?>
            </ul>
          </div>
        <?php endif; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
<!-- end: Hamburger Menu -->