<?php
$footerLogo = $settings['tj_logo'] ?? "";
$footerDesc = $settings['tj_desc'] ?? "";

// animation
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay']['size'] ?? '';

$wrapClass = "footer-widget";

if (!empty($tjAnimation) && !empty($tjAnimationName)) {
  $wrapClass .= " wow " . esc_attr($tjAnimationName);

  if (!empty($tjAnimationDelay)) {
    $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', esc_attr($tjAnimationDelay . "s"));
  }
}

$this->add_render_attribute('tj_wrap_arg', 'class', esc_attr($wrapClass));

?>

<div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?>>
  <?php if (!empty($footerLogo['url'])): ?>
    <!-- footer logo -->
    <div class="footer-logo">
      <a href="<?php echo esc_url(home_url('/')); ?>" class="logo">
        <img src="<?php echo esc_url($footerLogo['url']); ?>" alt="<?php echo esc_attr(get_post_meta($footerLogo['id'], '_wp_attachment_image_alt', true)); ?>" />
      </a>
    </div>
  <?php endif; ?>
  <?php if (!empty($footerDesc)): ?>
    <div class="footer-text">
      <p class="tj-el-desc"><?php echo tj_kses($footerDesc); ?></p>
    </div>
  <?php endif; ?>
</div>