<?php
$ctaLeftTitle = $settings['tj_left_title'] ?? "";
$ctaRightTitle = $settings['tj_right_title'] ?? "";

$tj_gsap_animation   = $settings['tj_gsap_animation'] ?? '';
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjTitleAnimation)) {
  $titleClass = "title tj-el-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} elseif ($tj_gsap_animation) {
  $titleClass = "title tj-el-title text-anim";
} else {
  $titleClass = "title tj-el-title";
}

$this->add_render_attribute('title_args', 'class', $titleClass);

// thumb
$tjImage = $settings['tj_image'] ?? '';

$tjThumbAnimation   = $settings['tj_thumb_animation'] ?? '';
$tjThumbAnimationName   = $settings['tj_thumb_animation_name'] ?? '';
$tjThumbAnimationDelay   = $settings['tj_thumb_animation_delay']['size'] ?? '';

// button
$thumbClass = "cta-img";
if (!empty($tjThumbAnimation)) {
  $thumbClass .= " wow $tjThumbAnimationName";
  $this->add_render_attribute('tj_thumb_arg', 'data-wow-delay', "{$tjThumbAnimationDelay}s");
}
$this->add_render_attribute('tj_thumb_arg', 'class', $thumbClass);

// button
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}
$this->add_render_attribute('tj_button_arg', 'class', "tji-icon-btn");

$overlyImage = $settings['tj_overlay_image'] ?? "";
?>

<!-- start: Cta Section -->
<div class="h9-cta-section tj-el-section">
  <?php if (!empty($overlyImage['url'])): ?>
    <div class="cta-bg" data-bg-image="<?php echo esc_url($overlyImage['url']); ?>"></div>
  <?php endif; ?>

  <div class="container">
    <div class="row">
      <div class="col-12">
        <div class="cta-content">
          <h2 <?php $this->print_render_attribute_string('title_args') ?>>
            <?php if (!empty($ctaLeftTitle)): ?>
              <span><?php echo esc_html($ctaLeftTitle); ?></span>
            <?php endif; ?>

            <?php if (!empty($tjImage['url'])): ?>
              <span <?php $this->print_render_attribute_string('tj_thumb_arg'); ?>>
                <img src="<?php echo esc_url($tjImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjImage['id'], '_wp_attachment_image_alt', true)); ?>">

                <?php if (!empty($tjBtnIcon['value'])) : ?>
                  <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
                    <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                  </a>
                <?php endif; ?>
              </span>
            <?php endif; ?>

            <?php if (!empty($ctaRightTitle)): ?>
              <span><?php echo esc_html($ctaRightTitle); ?></span>
            <?php endif; ?>
          </h2>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- end: Cta Section -->