<?php
$tjCounterCount   = $settings['tj_ff_number'] ?? '';
$tjCounterPrefix  = $settings['tj_ff_prefix'] ?? '';
$tjCounterSuffix  = $settings['tj_ff_suffix'] ?? '';
$tjCounterTitle   = $settings['tj_ff_title'] ?? '';
$tjCounterDesc   = $settings['tj_ff_desc'] ?? '';
$tjCounterIcon    = $settings['tj_ff_icon'] ?? [];
$tjCounterSteps   = $settings['tj_ff_steps'] ?? '';

// animation
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay']['size'] ?? '';

$counterClass = "countup-item style-2 tj-el-counter";
if (!empty($tjAnimation)) {
  $counterClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-counter-arg', 'data-wow-delay', $tjAnimationDelay . 's');
}
$this->add_render_attribute('tj-counter-arg', 'class', $counterClass);
?>

<div class="h7-about-counter-wrapper">
  <div <?php echo $this->get_render_attribute_string('tj-counter-arg'); ?>>

    <?php if (!empty($tjCounterTitle)) : ?>
      <p class="counter-title tj-el-title"><?php echo tj_kses($tjCounterTitle); ?></p>
    <?php endif; ?>
    <?php if (!empty($tjCounterSteps)) : ?>
      <span class="steps tj-el-steps"><?php echo esc_html($tjCounterSteps); ?></span>
    <?php endif; ?>

    <?php if (!empty($tjCounterIcon['value'])) : ?>
      <span class="count-icon tj-el-icon">
        <?php \Elementor\Icons_Manager::render_icon($tjCounterIcon, ['aria-hidden' => 'true']); ?>
      </span>
    <?php endif; ?>

    <div class="count-inner">
      <?php if (is_numeric($tjCounterCount)) : ?>
        <div class="inline-content tj-el-number">
          <?php echo tj_kses($tjCounterPrefix); ?><span class="counter"><?php echo esc_html($tjCounterCount); ?></span><span class="count-plus"><?php echo tj_kses($tjCounterSuffix); ?></span>
        </div>
      <?php endif; ?>
      <?php if (!empty($tjCounterDesc)): ?>
        <span class="count-text tj-el-desc"> <?php echo tj_kses($tjCounterDesc); ?></span>
      <?php endif; ?>
    </div>
  </div>
</div>