<?php
$counter_items     = $settings['tj_counter_list'] ?? [];
$tj_divider       = $settings['tj_divider'] ?? '';
$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

$wrapper_class     = 'countup-wrap tj-el-section';

if ($tjAnimation === 'yes' && !empty($tjAnimationName)) {
  $wrapper_class .= ' wow ' . esc_attr($tjAnimationName);
  $this->add_render_attribute('counter_loop_wrapper', 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
}
$this->add_render_attribute('counter_loop_wrapper', 'class', $wrapper_class);
?>

<div <?php echo $this->get_render_attribute_string('counter_loop_wrapper'); ?>>

  <?php foreach ($counter_items as $index => $item) :
    $title  = $item['tj_ff_title'] ?? '';
    $number = $item['tj_ff_number'] ?? '';
    $prefix = $item['tj_ff_prefix'] ?? '';
    $suffix = $item['tj_ff_suffix'] ?? '';
  ?>
    <div class="countup-item">
      <div class="inline-content tj-el-number">
        <?php if (!empty($prefix)) : ?>
          <span class="prefix"><?php echo tj_kses($prefix); ?></span>
        <?php endif; ?>
        <?php if (!empty($number)) : ?>
          <span class="counter"><?php echo tj_kses($number); ?></span>
        <?php endif; ?>
        <?php if (!empty($suffix)) : ?>
          <span class="count-plus suffix"><?php echo tj_kses($suffix); ?></span>
        <?php endif; ?>
      </div>
      <?php if (!empty($title)) : ?>
        <span class="count-text tj-el-title"><?php echo tj_kses($title); ?></span>
      <?php endif; ?>
      <?php if (!empty($tj_divider)) : ?>
        <span class="count-separator" data-bg-image="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shape/separator.svg"></span>
      <?php endif; ?>
    </div>
  <?php endforeach; ?>

</div>