<?php
$btnCircleImage           = $settings['tj_circle_image'] ?? '';
$btnIcon           = $settings['tj_btn_icon'] ?? '';
$btnLinkType       = $settings['tj_btn_link_type'] ?? '';
$btnLink           = $settings['tj_btn_link'] ?? [];
$btnPageLink       = $settings['tj_btn_page_link'] ?? '';

$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

// Initialize button class
$btnClass = 'h8-team-action tj-el-btn';

if (!empty($tjAnimation) && !empty($tjAnimationName)) {
  $btnClass .= ' wow ' . esc_attr($tjAnimationName);
  $this->add_render_attribute('tj_btn_wrap_attr', 'data-wow-delay', esc_attr($tjAnimationDelay . 's'));
}
$this->add_render_attribute('tj_btn_wrap_attr', 'class', $btnClass);

if ($btnLinkType === '2' && !empty($btnPageLink)) {
  $this->add_render_attribute('tj_btn_attr', 'href', esc_url(get_permalink($btnPageLink)));
  $this->add_render_attribute('tj_btn_attr', 'target', '_self');
  $this->add_render_attribute('tj_btn_attr', 'rel', 'nofollow');
} elseif (!empty($btnLink['url'])) {
  $this->add_link_attributes('tj_btn_attr', $btnLink);
}
$this->add_render_attribute('tj_btn_attr', 'class', "circle-icon");
?>

<div <?php $this->print_render_attribute_string('tj_btn_wrap_attr'); ?>>
  <div class="circle-text-wrap">
    <?php if (!empty($btnCircleImage['url'])): ?>
      <span class="circle-text" data-bg-image="<?php echo esc_url($btnCircleImage['url']); ?>"></span>
    <?php endif; ?>

    <?php if (!empty($btnIcon['value'])) : ?>
      <a <?php echo $this->get_render_attribute_string('tj_btn_attr'); ?>>
        <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
      </a>
    <?php endif; ?>
  </div>
</div>