<?php

$tjSectionSubtitle   = $settings['tj_subtitle'] ?? "";
// animation
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';
if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "h6-hero-history wow $tjSubtitleAnimationName";
  $this->add_render_attribute('subtitle_arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "h6-hero-history";
}
$this->add_render_attribute('subtitle_arg', 'class', $subtitleClass);

// title
$tjSectionTitle   = $settings['tj_title'] ?? "";
$tjSectionTitleTag   = $settings['tj_title_tag'] ?? "h1";
// animation
$tj_gsap_animation   = $settings['tj_gsap_animation'] ?? '';
$tjGsapAnimationType   = $settings['animation_type'] ?? '';
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';
if (!empty($tjTitleAnimation)) {
  $titleClass = "banner-title tj-el-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} elseif (!empty($tj_gsap_animation) || !empty($tjGsapAnimationType)) {
  $titleClass = "banner-title tj-el-title $tjGsapAnimationType";
} else {
  $titleClass = "banner-title tj-el-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

// desc
$tjBannerDesc = $settings['tj_banner_desc'] ?? "";
$tjDescAnimation = $settings['tj_desc_animation'] ?? '';
$tjDescAnimationName = $settings['tj_desc_animation_name'] ?? '';
$tjDescAnimationDelay = $settings['tj_desc_animation_delay'] ?? '';

$descClass = "banner-desc tj-el-desc";
if (!empty($tjDescAnimation)) {
  $descClass .= " wow $tjDescAnimationName";
  $this->add_render_attribute('tj_desc_args', 'data-wow-delay', $tjDescAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_desc_args', 'class', $descClass);

// video
$videoImage = $settings['video_image']['url'] ?? '';
$videoUrl = $settings['video_link']['url'] ?? '';
$autoplay = !empty($settings['video_autoplay']) ? 'autoplay playsinline' : '';
$controls = !empty($settings['video_controler']) ? 'controls' : '';
$loop = !empty($settings['video_loop']) ? 'loop' : '';
$muted = !empty($settings['video_muted']) ? 'muted' : '';

// button
$tjButtonShow = $settings['tj_button_show'] ?? '';
$tjBtnText = $settings['tj_btn_text'] ?? '';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';

$btnClass = "tj-primary-btn";
if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}
if (!empty($tjButtonAnimation)) {
  $btnClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_button_arg', 'data-wow-delay', $tjButtonAnimationDelay['size'] . "s");
}

$this->add_render_attribute('tj_button_arg', 'class', $btnClass);

// Counter + Client
$counter_animation = $settings['counter_animation'] ?? '';
$counter_animation_name  = $settings['counter_animation_name'] ?? '';
$counter_animation_delay = $settings['counter_animation_delay'] ?? '';

$counterClass = 'circle-text-wrap tj-el-box';
if (!empty($counter_animation)) {
  $counterClass .= " wow $counter_animation_name";
  $this->add_render_attribute('tj_counter_wrap', 'data-wow-delay', $counter_animation_delay['size'] . "s");
}
$this->add_render_attribute('tj_counter_wrap', 'class', $counterClass);

?>

<section class="tj-banner-section-2 h10-hero tj-el-section zoom-on-scroll-wrapper">
  <div class="container">
    <div class="row flex-column-reverse flex-lg-row">
      <div class="col-lg-4 col-xl-3">
        <div class="h10-hero-award-wrapper">
          <?php if (!empty($tjSectionSubtitle)) : ?>
            <div <?php echo $this->get_render_attribute_string('subtitle_arg'); ?>>
              <div class="h6-hero-history-title"></div>
              <p class="h6-hero-history-desc tj-el-subtitle">
                <?php if (!empty($tj_subtitle_icon['value']) && !empty($subtitle_icon_show)): ?>
                  <?php tj_render_icon($settings, 'tj_subtitle_icon') ?>
                <?php endif; ?>
                <?php echo tj_kses($tjSectionSubtitle); ?>
              </p>
            </div>
          <?php endif; ?>
          <?php if (!empty($tj_custom_html)): ?>
            <div <?php echo $this->get_render_attribute_string('tj_counter_wrap'); ?>>
              <?php echo tj_kses($tj_custom_html); ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
      <div class="col-lg-8 col-xl-9">
        <div class="banner-content-2">

          <?php
          if (!empty($tjSectionTitle)) :
            printf(
              '<%1$s %2$s>%3$s</%1$s>',
              tag_escape($tjSectionTitleTag),
              $this->get_render_attribute_string('title_args'),
              tj_kses($tjSectionTitle)
            );
          endif;
          ?>

          <div class="banner-desc-area">

            <?php if ("yes" == $tjButtonShow): ?>
              <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
                <span class="btn-text"><span> <?php echo tj_kses($tjBtnText); ?></span></span>
                <?php if (!empty($tjBtnIcon['value'])): ?>
                  <span class="btn-icon">
                    <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                  </span>
                <?php endif; ?>
              </a>
            <?php endif; ?>

            <?php if (!empty($tjBannerDesc)) : ?>
              <div <?php echo $this->get_render_attribute_string('tj_desc_args'); ?>>
                <?php echo tj_kses($tjBannerDesc); ?>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Background video -->
  <?php if (!empty($videoUrl) || !empty($videoImage)) : ?>
    <div class="container-fluid p-0 gap-0">
      <div class="row">
        <div class="col-12">
          <div class="h10-hero-banner zoom-on-scroll">
            <div class="h10-hero-banner-img h10-hero-banner-video">
              <video <?php echo $autoplay . ' ' . $controls . ' ' . $loop . ' ' . $muted; ?> data-wf-ignore="true" data-object-fit="cover" poster="<?php echo esc_url($videoImage); ?>">
                <source src="<?php echo esc_url($videoUrl); ?>" type="video/mp4" />
              </video>
            </div>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <?php if (!empty($settings['tj_banner_left_shape']['url'])): ?>
    <div class="bg-shape-1">
      <img src="<?php echo esc_url($settings['tj_banner_left_shape']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_banner_left_shape']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>
  <?php if (!empty($settings['tj_banner_right_shape']['url'])): ?>
    <div class="bg-shape-2">
      <img src="<?php echo esc_url($settings['tj_banner_right_shape']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_banner_right_shape']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>

</section>