<?php
// Get repeater items
$banner_items = $settings['tj_banner_list'] ?? [];


$btn_image    = $settings['tj_btn_image'] ?? [];
$link_type    = $settings['tj_cbtn_link_type'] ?? '1';
$custom_link  = $settings['tj_cbtn_link'] ?? [];
$page_link    = $settings['tj_cbtn_page_link'] ?? '';
$icon         = $settings['tj_cbtn_icon'] ?? [];

// Link attributes setup

$link_attrs = "tj_circle_btn";

if ($link_type == '2' && !empty($page_link)) {
  $this->add_render_attribute($link_attrs, 'href', esc_url(get_permalink($page_link)));
  $this->add_render_attribute($link_attrs, 'target', '_self');
  $this->add_render_attribute($link_attrs, 'rel', 'nofollow');
} elseif (!empty($custom_link['url'])) {
  $this->add_link_attributes($link_attrs, $custom_link);
}

$loop              = $settings['slide_loop'] ?? 'no';
$nav               = $settings['slide_nav'] ?? 'no';
$autoplay          = $settings['slide_autoplay'] ?? 'no';
$autoplayDelay     = $settings['slide_autoplay_Delay'] ?? 5000;

?>

<section class="tj-slider-section fix carouselWrap" data-loop="<?php echo esc_attr($loop); ?>" data-nav="<?php echo esc_attr($nav); ?>" data-autoplay="<?php echo esc_attr($autoplay); ?>" data-delay="<?php echo esc_attr($autoplayDelay); ?>">
  <div class="swiper hero-slider">
    <div class="swiper-wrapper">

      <?php foreach ($banner_items as $index => $item) :
        $image       = $item['tj_banner_image']['url'] ?? '';
        $title       = $item['tj_banner_title'] ?? '';
        $desc        = $item['tj_banner_desc'] ?? '';
        $btn_text    = $item['tj_banner_btn'] ?? '';
        $btn_icon    = $item['tj_banner_btn_icon'] ?? [];
        $link_type   = $item['tj_banner_link_type'] ?? '1';
        $custom_link = $item['tj_banner_link'] ?? [];
        $page_link   = $item['tj_banner_page_link'] ?? '';

        // Setup button link attributes
        $btn_attrs = "banner_link_{$index}";

        if ($link_type == '2' && !empty($page_link)) {
          $this->add_render_attribute($btn_attrs, 'href', esc_url(get_permalink($page_link)));
          $this->add_render_attribute($btn_attrs, 'target', '_self');
          $this->add_render_attribute($btn_attrs, 'rel', 'nofollow');
        } elseif (!empty($custom_link['url'])) {
          $this->add_link_attributes($btn_attrs, $custom_link);
        }

      ?>

        <div class="swiper-slide tj-slider-item tj-el-slide">
          <?php if (!empty($image)) : ?>
            <div class="slider-bg-image" data-bg-image="<?php echo esc_url($image); ?>"></div>
          <?php endif; ?>

          <div class="container">
            <div class="slider-wrapper">
              <div class="slider-content">
                <?php if (!empty($title)) : ?>
                  <h1 class="slider-title tj-el-title"><?php echo tj_kses($title); ?></h1>
                <?php endif; ?>

                <?php if (!empty($desc)) : ?>
                  <div class="slider-desc tj-el-desc"><?php echo tj_kses($desc); ?></div>
                <?php endif; ?>

                <?php if (!empty($btn_text)) : ?>
                  <div class="slider-btn">
                    <a class="tj-primary-btn" <?php echo $this->get_render_attribute_string($btn_attrs); ?>>
                      <span class="btn-text"><span><?php echo esc_html($btn_text); ?></span></span>
                      <?php if (!empty($btn_icon['value'])) : ?>
                        <span class="btn-icon"><?php tj_render_icon($item, 'tj_banner_btn_icon', 'btn-icon'); ?></span>
                      <?php endif; ?>
                    </a>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>

      <?php endforeach; ?>

    </div>
    <?php if ($nav === 'yes') : ?>
      <div class="hero-navigation d-inline-flex wow fadeIn" data-wow-delay="1.5s">
        <div class="slider-prev">
          <span class="anim-icon"><i class="tji-arrow-left"></i><i class="tji-arrow-left"></i></span>
        </div>
        <div class="slider-next">
          <span class="anim-icon"><i class="tji-arrow-right"></i><i class="tji-arrow-right"></i></span>
        </div>
      </div>
    <?php endif; ?>
  </div>

  <div class="swiper hero-thumb wow fadeIn" data-wow-delay="2s">
    <div class="swiper-wrapper">
      <?php foreach ($banner_items as $item) :
        $image = $item['tj_banner_image']['url'] ?? '';
        $image_id  = $item['tj_banner_image']['id'] ?? '';

        if ($image) : ?>
          <div class="swiper-slide thumb-item">
            <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr(get_post_meta($image_id, '_wp_attachment_image_alt', true)); ?>">
          </div>
      <?php endif;
      endforeach; ?>
    </div>
  </div>


  <?php if (!empty($btn_image['url']) || !empty($icon['value'])) : ?>
    <div class="circle-text-wrap wow fadeInUp" data-wow-delay="2.2s">
      <?php if (!empty($btn_image['url'])) : ?>
        <span class="circle-text" data-bg-image="<?php echo esc_url($btn_image['url']); ?>"></span>
      <?php endif; ?>

      <a class="circle-icon" <?php echo $this->get_render_attribute_string($link_attrs); ?>>
        <?php if (!empty($icon['value'])) : ?>
          <i class="<?php echo esc_attr($icon['value']); ?>"></i>
        <?php endif; ?>
      </a>
    </div>
  <?php endif; ?>
</section>