<?php
$accordionList     = $settings['tj_accordion_list'] ?? [];
$accordion_id      = $this->get_id(); // unique ID for this accordion instance

?>

<div class="accordion tj-faq style-2" id="accordion-<?php echo esc_attr($accordion_id); ?>">

  <?php foreach ($accordionList as $index => $item) :
    $question        = $item['tj_accordion_question'] ?? '';
    $answer          = $item['tj_accordion_answer'] ?? '';
    $is_expand       = $item['is_expand'] === 'yes';
    $itemAnim        = $item['tj_animation'] ?? '';
    $itemAnimName    = $item['tj_animation_name'] ?? '';
    $itemDelay       = $item['tj_animation_delay']['size'] ?? '';

    $collapse_id     = 'faq-' . esc_attr($accordion_id . '-' . $index);
    $show_class      = $is_expand ? 'show' : '';
    $expanded        = $is_expand ? 'true' : 'false';
    $button_class    = $is_expand ? 'collapsed' : '';
    $item_class      = 'accordion-item';
    $item_attrs      = '';

    if ($is_expand) {
      $item_class .= ' active';
    }

    if ($itemAnim === 'yes') {
      $item_class .= ' wow ' . esc_attr($itemAnimName);
      $item_attrs = ' data-wow-delay="' . esc_attr($itemDelay) . 's"';
    }
  ?>
    <div class="<?php echo esc_attr($item_class); ?>" <?php echo $item_attrs; ?>>
      <button class="faq-title <?php echo esc_attr($button_class); ?>"
        type="button"
        data-bs-toggle="collapse"
        data-bs-target="#<?php echo esc_attr($collapse_id); ?>"
        aria-expanded="<?php echo esc_attr($expanded); ?>"
        aria-controls="<?php echo esc_attr($collapse_id); ?>">
        <?php echo esc_html($question); ?>
      </button>

      <div id="<?php echo esc_attr($collapse_id); ?>"
        class="collapse <?php echo esc_attr($show_class); ?>"
        data-bs-parent="#accordion-<?php echo esc_attr($accordion_id); ?>">
        <div class="accordion-body faq-text">
          <p><?php echo esc_html($answer); ?></p>
        </div>
      </div>
    </div>
  <?php endforeach; ?>

</div>