(function ($) {
	"use strict";
	/**
	 * @param $scope The Widget wrapper element as a jQuery element
	 * @param $ The jQuery alias
	 */
	// Make sure you run this code under Elementor.
	$(window).on("elementor/frontend/init", function () {
		// global widget
		elementorFrontend.hooks.addAction("frontend/element_ready/widget", function ($scope, $) {
			// background image
			let bgImage = $scope.find("[data-bg-image]");
			if (bgImage.length > 0) {
				bgImage.each(function () {
					$(this).css("background-image", "url(" + $(this).attr("data-bg-image") + ")");
				});
			}
			//mask image
			let maskImage = $scope.find("[data-mask]");
			if (maskImage.length > 0) {
				maskImage.each(function () {
					$(this).css("mask-image", "url(" + $(this).attr("data-mask") + ")");
				});
			}
		});

		// tj-coming-soon
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-coming-soon.default",

			function ($scope, $) {
				const $wrap = $scope.find(".countdown");

				if ($wrap.length > 0) {
					const dateVal = $wrap.data("date");
					const targetTime = new Date(dateVal).getTime();

					// ⛔ Prevent NaN countdown
					if (!dateVal || isNaN(targetTime)) {
						$wrap.find(".countdown-value").text("00");
						return;
					}

					const labels = {
						day: $wrap.data("day_label") || "Days",
						hour: $wrap.data("hour_label") || "Hours",
						min: $wrap.data("min_label") || "Mins",
						sec: $wrap.data("sec_label") || "Sec",
					};

					// Cache elements once
					const el = {
						days: $wrap.find(".days .countdown-value"),
						hours: $wrap.find(".hours .countdown-value"),
						mins: $wrap.find(".minutes .countdown-value"),
						secs: $wrap.find(".seconds .countdown-value"),
						labelDays: $wrap.find(".days .countdown-heading"),
						labelHours: $wrap.find(".hours .countdown-heading"),
						labelMins: $wrap.find(".minutes .countdown-heading"),
						labelSecs: $wrap.find(".seconds .countdown-heading"),
					};

					const pad = n => String(n).padStart(2, "0");

					// Labels set once
					el.labelDays.text(labels.day);
					el.labelHours.text(labels.hour);
					el.labelMins.text(labels.min);
					el.labelSecs.text(labels.sec);

					function tick() {
						const now = Date.now();
						const diff = targetTime - now;

						if (diff <= 0) {
							el.days.text("00");
							el.hours.text("00");
							el.mins.text("00");
							el.secs.text("00");
							clearInterval(timer);
							return;
						}

						const d = Math.floor(diff / 86400000);
						const h = Math.floor((diff / 3600000) % 24);
						const m = Math.floor((diff / 60000) % 60);
						const s = Math.floor((diff / 1000) % 60);

						el.days.text(pad(d));
						el.hours.text(pad(h));
						el.mins.text(pad(m));
						el.secs.text(pad(s));
					}

					tick();
					const timer = setInterval(tick, 1000);
				}
			}
		);

		// banner-slider
		elementorFrontend.hooks.addAction("frontend/element_ready/tj-banner-slider.default", function ($scope, $) {
			let wrap = $scope.find(".carouselWrap");

			let loop = wrap.attr("data-loop") == "yes" ? true : false;
			let nav = wrap.attr("data-nav") == "yes" ? true : false;
			let autoplay = wrap.attr("data-autoplay") == "yes" ? true : false;
			let delay = wrap.attr("data-delay") ? wrap.attr("data-delay") : "5000";

			const $thumb = $scope.find(".hero-thumb");
			const $slider = $scope.find(".hero-slider");

			let swiperThumb = null;

			// Initialize thumbnail swiper
			if ($thumb.length) {
				swiperThumb = new Swiper($thumb[0], {
					loop: false,
					spaceBetween: 15,
					slidesPerView: 3,
					freeMode: true,
					watchSlidesProgress: true,
				});
			}

			// Initialize main hero slider
			if ($slider.length) {
				new Swiper($slider[0], {
					slidesPerView: 1,
					spaceBetween: 0,
					effect: "fade",
					loop: loop,
					speed: 1400,
					...(autoplay
						? {
								autoplay: {
									delay: delay,
								},
						  }
						: {}),
					...(nav
						? {
								navigation: {
									nextEl: $scope.find(".slider-next")[0],
									prevEl: $scope.find(".slider-prev")[0],
								},
						  }
						: {}),

					thumbs: swiperThumb ? {swiper: swiperThumb} : undefined,
				});
			}
		});

		// tj-brand
		elementorFrontend.hooks.addAction("frontend/element_ready/tj-brand-carousel.default", function ($scope, $) {
			let wrap = $scope.find(".carouselWrap");

			let loop = wrap.attr("data-loop") == "yes" ? true : false;
			let autoplay = wrap.attr("data-autoplay") == "yes" ? true : false;
			let delay = wrap.attr("data-delay") ? wrap.attr("data-delay") : "1";

			// slider 1
			let brandSlider = $scope.find(".client-slider");
			if (brandSlider.length > 0) {
				const carouselID = brandSlider.attr("id");

				var brand = new Swiper(`#${carouselID}`, {
					slidesPerView: "auto",
					spaceBetween: 0,
					freemode: true,
					centeredSlides: true,
					loop: loop,
					speed: 5000,
					allowTouchMove: false,
					...(autoplay
						? {
								autoplay: {
									delay: delay,
									disableOnInteraction: true,
								},
						  }
						: {}),
				});
			}
		});

		// Service slider
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-service-slider.default",

			function ($scope, $) {
				let wrap = $scope.find(".carouselWrap");

				let loop = wrap.attr("data-loop") == "yes" ? true : false;
				let dot = wrap.attr("data-dot") == "yes" ? true : false;
				let autoplay = wrap.attr("data-autoplay") == "yes" ? true : false;
				let delay = wrap.attr("data-delay") ? wrap.attr("data-delay") : "2000";

				let serviceSlider = $scope.find(".service-slider");

				if (serviceSlider.length > 0) {
					let sliderID = serviceSlider.attr("id");
					var serviceCarousel = new Swiper(`#${sliderID}`, {
						slidesPerView: 4.2,
						spaceBetween: 28,
						centeredSlides: true,
						loop: loop,
						speed: 1500,
						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
						breakpoints: {
							0: {
								slidesPerView: 1.3,
								spaceBetween: 15,
							},
							576: {
								slidesPerView: 2,
								spaceBetween: 15,
							},
							768: {
								slidesPerView: 2.3,
								spaceBetween: 15,
							},
							900: {
								slidesPerView: 2.6,
								spaceBetween: 15,
							},
							1025: {
								slidesPerView: 3.2,
								spaceBetween: 15,
							},
							1201: {
								slidesPerView: 3.4,
								spaceBetween: 28,
							},
							1400: {
								slidesPerView: 4.2,
							},
						},
					});
				}

				// slider 2
				let serviceSlider2 = $scope.find(".service-slider-2");
				if (serviceSlider2.length > 0) {
					let sliderID = serviceSlider2.attr("id");
					var serviceCarousel = new Swiper(`#${sliderID}`, {
						slidesPerView: 4,
						spaceBetween: 28,
						centeredSlides: false,
						loop: loop,
						speed: 1500,
						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
						breakpoints: {
							0: {
								slidesPerView: 1.3,
								spaceBetween: 15,
							},
							576: {
								slidesPerView: 2,
								spaceBetween: 15,
							},
							1025: {
								slidesPerView: 3,
								spaceBetween: 15,
							},
							1201: {
								slidesPerView: 4,
								spaceBetween: 20,
							},
							1400: {
								slidesPerView: 4,
								spaceBetween: 28,
							},
						},
					});
				}

				// slider 3
				let serviceSlider3 = $scope.find(".h6-service-slider");
				if (serviceSlider3.length > 0) {
					let sliderID = serviceSlider3.attr("id");
					var serviceCarousel = new Swiper(`#${sliderID}`, {
						slidesPerView: 1,
						spaceBetween: 15,
						loop: loop,
						speed: 1500,
						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
						breakpoints: {
							768: {
								slidesPerView: 2,
								spaceBetween: 30,
							},
							1201: {
								slidesPerView: 3,
								spaceBetween: 30,
							},
						},
					});
				}

				// slider 4
				let serviceSlider4 = $scope.find(".h10-service-slider");
				if (serviceSlider4.length > 0) {
					let sliderID = serviceSlider4.attr("id");
					var serviceCarousel = new Swiper(`#${sliderID}`, {
						slidesPerView: 1,
						spaceBetween: 15,
						centeredSlides: false,
						loop: loop,
						speed: 1500,
						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
						breakpoints: {
							768: {
								slidesPerView: 2,
								spaceBetween: 20,
							},
							1025: {
								slidesPerView: 2,
								spaceBetween: 30,
							},
							1201: {
								spaceBetween: 20,
								slidesPerView: 3,
							},
							1400: {
								spaceBetween: 30,
								slidesPerView: 3,
							},
						},
					});
				}
			}
		);

		// Project slider
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-project-slider.default",

			function ($scope, $) {
				let wrap = $scope.find(".carouselWrap");

				let loop = wrap.attr("data-loop") == "yes" ? true : false;
				let nav = wrap.attr("data-nav") == "yes" ? true : false;
				let dot = wrap.attr("data-dot") == "yes" ? true : false;
				let autoplay = wrap.attr("data-autoplay") == "yes" ? true : false;
				let delay = wrap.attr("data-delay") ? wrap.attr("data-delay") : "2000";

				// project slider 1
				let projectSlider = $scope.find(".project-slider");
				if (projectSlider.length > 0) {
					let sliderID = projectSlider.attr("id");
					var projectCarousel = new Swiper(`#${sliderID}`, {
						slidesPerView: 3,
						spaceBetween: 30,
						centeredSlides: true,
						loop: loop,
						speed: 1500,
						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						...(nav
							? {
									navigation: {
										nextEl: ".slider-next",
										prevEl: ".slider-prev",
									},
							  }
							: {}),
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
						breakpoints: {
							0: {
								slidesPerView: 1.2,
								spaceBetween: 15,
							},
							576: {
								slidesPerView: 1.7,
								spaceBetween: 20,
							},
							768: {
								slidesPerView: 2,
								spaceBetween: 20,
							},
							992: {
								slidesPerView: 2,
							},
							1025: {
								slidesPerView: 2.2,
							},
							1400: {
								slidesPerView: 2.31,
							},
						},
					});
				}

				// project slider 2
				let projectSlider2 = $scope.find(".project-slider-2");
				if (projectSlider2.length > 0) {
					let sliderID = projectSlider2.attr("id");
					var projectCarousel = new Swiper(`#${sliderID}`, {
						slidesPerView: 4,
						spaceBetween: 30,
						loop: loop,
						speed: 1500,
						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						...(nav
							? {
									navigation: {
										nextEl: ".slider-next",
										prevEl: ".slider-prev",
									},
							  }
							: {}),
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
						breakpoints: {
							0: {
								slidesPerView: 1.2,
								spaceBetween: 15,
							},
							580: {
								slidesPerView: 2,
								spaceBetween: 20,
							},
							1025: {
								slidesPerView: 3,
								spaceBetween: 20,
							},
							1500: {
								slidesPerView: 4,
								spaceBetween: 30,
							},
						},
					});
				}

				// project slider 3
				let projectSlider3 = $scope.find(".project-slider-3");
				if (projectSlider3.length > 0) {
					let sliderID = projectSlider3.attr("id");
					var projectCarousel = new Swiper(`#${sliderID}`, {
						slidesPerView: 3,
						spaceBetween: 30,
						loop: loop,
						speed: 1500,
						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						...(nav
							? {
									navigation: {
										nextEl: ".slider-next",
										prevEl: ".slider-prev",
									},
							  }
							: {}),
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
						breakpoints: {
							0: {
								slidesPerView: 1.2,
								spaceBetween: 15,
							},
							576: {
								slidesPerView: 1.5,
								spaceBetween: 20,
							},
							768: {
								slidesPerView: 2,
								spaceBetween: 20,
							},
							1025: {
								slidesPerView: 2.4,
							},
							1201: {
								slidesPerView: 3,
							},
						},
					});
				}

				// project slider 4
				let projectSlider4 = $scope.find(".h8-project-slider");
				if (projectSlider4.length > 0) {
					let sliderID = projectSlider4.attr("id");

					var projectCarousel = new Swiper(`#${sliderID}`, {
						slidesPerView: 1,
						spaceBetween: 15,
						centeredSlides: false,
						loop: loop,
						speed: 1500,
						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						...(nav
							? {
									navigation: {
										nextEl: ".slider-next",
										prevEl: ".slider-prev",
									},
							  }
							: {}),
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
						breakpoints: {
							576: {
								slidesPerView: 1.5,
							},
							768: {
								slidesPerView: 1.3,
							},
							1025: {
								slidesPerView: 1.8,
								spaceBetween: 30,
							},
						},
					});
				}

				// project slider 5
				let projectSlider5 = $scope.find(".h9-project-slider");
				if (projectSlider5.length > 0) {
					let sliderID = projectSlider5.attr("id");

					var projectCarousel = new Swiper(`#${sliderID}`, {
						slidesPerView: 1.1,
						spaceBetween: 15,
						loop: loop,
						speed: 1500,
						centeredSlides: true,
						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						...(nav
							? {
									navigation: {
										nextEl: ".slider-next",
										prevEl: ".slider-prev",
									},
							  }
							: {}),
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
						breakpoints: {
							0: {
								centeredSlides: false,
							},
							576: {
								slidesPerView: 1.3,
							},
							680: {
								slidesPerView: 1.5,
								spaceBetween: 20,
							},
							1025: {
								slidesPerView: 2.3,
								spaceBetween: 20,
							},
							1201: {
								slidesPerView: 2.5,
								spaceBetween: 20,
							},
							1400: {
								slidesPerView: 2.5,
								spaceBetween: 20,
							},
							1500: {
								slidesPerView: 4,
								spaceBetween: 30,
							},
						},
					});
				}
			}
		);

		// tj-testimonial
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-testimonial.default",

			function ($scope, $) {
				let wrap = $scope.find(".carouselWrap");

				let loop = wrap.attr("data-loop") == "yes" ? true : false;
				let nav = wrap.attr("data-nav") == "yes" ? true : false;
				let dot = wrap.attr("data-dot") == "yes" ? true : false;
				let autoplay = wrap.attr("data-autoplay") == "yes" ? true : false;
				let delay = wrap.attr("data-delay") ? wrap.attr("data-delay") : "5000";

				// rating
				if ($(".fill-ratings span").length > 0) {
					var star_rating_width = $(".fill-ratings span").width();
					$(".star-ratings").width(star_rating_width);
				}

				// slider one
				let testimonialSlider = $scope.find(".testimonial-slider");
				if (testimonialSlider.length > 0) {
					let sliderID = testimonialSlider.attr("id");
					var testimonialCarousel = new Swiper(`#${sliderID}`, {
						slidesPerView: 3,
						spaceBetween: 28,
						centeredSlides: true,
						loop: loop,
						speed: 1500,
						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						...(nav
							? {
									navigation: {
										nextEl: ".slider-next",
										prevEl: ".slider-prev",
									},
							  }
							: {}),
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
						breakpoints: {
							0: {
								slidesPerView: 1.2,
								spaceBetween: 15,
								centeredSlides: false,
							},
							576: {
								slidesPerView: 1.3,
								spaceBetween: 20,
								centeredSlides: false,
							},
							768: {
								slidesPerView: 1.4,
								spaceBetween: 20,
								centeredSlides: false,
							},
							1025: {
								slidesPerView: 3,
							},
							1201: {
								slidesPerView: 3,
							},
						},
					});
				}

				// slider two
				let testimonialSlider2 = $scope.find(".testimonial-slider-2");
				if (testimonialSlider2.length > 0) {
					let sliderID = testimonialSlider2.attr("id");
					var testimonialCarousel2 = new Swiper(`#${sliderID}`, {
						slidesPerView: 1,
						spaceBetween: 28,
						loop: loop,
						speed: 1500,
						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						...(nav
							? {
									navigation: {
										nextEl: ".slider-next",
										prevEl: ".slider-prev",
									},
							  }
							: {}),
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
					});
				}

				//slider three
				const $thumb = $scope.find(".client-thumb");
				const $slider = $scope.find(".testimonial-slider-3");
				if ($thumb.length && $slider.length) {
					const thumbSlider3 = new Swiper($thumb[0], {
						slidesPerView: 3,
						spaceBetween: 12,
						loop: loop,
						speed: 1500,
						centeredSlides: true,
						freeMode: true,
						watchSlidesProgress: true,
						slideToClickedSlide: true,
					});

					const testimonialSlider3 = new Swiper($slider[0], {
						slidesPerView: "auto",
						spaceBetween: 28,
						loop: loop,
						speed: 1500,
						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						...(nav
							? {
									navigation: {
										nextEl: $scope.find(".slider-next")[0],
										prevEl: $scope.find(".slider-prev")[0],
									},
							  }
							: {}),
						...(dot
							? {
									pagination: {
										el: $scope.find(".swiper-pagination-area")[0],
										clickable: true,
									},
							  }
							: {}),
					});

					// Sync sliders
					testimonialSlider3.controller.control = thumbSlider3;
					thumbSlider3.controller.control = testimonialSlider3;
				}

				// slider four
				let testimonialSlider4 = $scope.find(".h5-testimonial-slider");
				if (testimonialSlider4.length > 0) {
					let sliderID = testimonialSlider4.attr("id");

					var testimonialCarousel4 = new Swiper(`#${sliderID}`, {
						slidesPerView: 1.2,
						spaceBetween: 20,
						centeredSlides: true,
						loop: loop,
						speed: 1500,
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						breakpoints: {
							1025: {
								centeredSlides: false,
								slidesPerView: 2,
								spaceBetween: 30,
							},
						},
					});
				}

				// slider five
				let testimonialSlider5 = $scope.find(".h6-testimonial-slider");
				if (testimonialSlider5.length > 0) {
					let sliderID = testimonialSlider5.attr("id");

					let verticalTestimonialSlider6;
					function verticalTestimonialSlider() {
						const screenWidth = window.innerWidth;
						const direction = screenWidth >= 992 ? "vertical" : "horizontal";
						if (verticalTestimonialSlider6) {
							verticalTestimonialSlider6?.destroy(true, true);
						}
						verticalTestimonialSlider6 = new Swiper(`#${sliderID}`, {
							direction: direction,
							slidesPerView: 1,
							spaceBetween: 20,
							loop: loop,
							speed: 1500,
							...(autoplay
								? {
										autoplay: {
											delay: delay,
										},
								  }
								: {}),
							breakpoints: {
								576: {
									slidesPerView: 1.2,
								},
								1025: {
									slidesPerView: "auto",
									spaceBetween: 30,
								},
							},
						});
					}
					verticalTestimonialSlider();
					// Reinitialize on resize
					window.addEventListener("resize", () => {
						verticalTestimonialSlider();
					});
				}

				// slider Six
				let testimonialSlider6 = $scope.find(".h8-testimonial-slider");
				if (testimonialSlider6.length > 0) {
					let sliderID = testimonialSlider6.attr("id");

					var swiper = new Swiper(`#${sliderID}`, {
						slidesPerView: 1,
						spaceBetween: 20,
						centeredSlides: true,
						loop: loop,
						speed: 1500,
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
						...(autoplay
							? {
									autoplay: {
										delay: delay,
										disableOnInteraction: true,
									},
							  }
							: {}),
						breakpoints: {
							576: {
								slidesPerView: 1.5,
							},
							768: {
								slidesPerView: 2,
							},
							1025: {
								slidesPerView: 2.2,
								spaceBetween: 30,
							},
							1201: {
								slidesPerView: 2.8,
								spaceBetween: 30,
							},
							1400: {
								slidesPerView: 4,
								spaceBetween: 30,
							},
						},
					});
				}

				// slider Seven
				let testimonialSlider7 = $scope.find(".h10-testimonial-slider");
				if (testimonialSlider7.length > 0) {
					let sliderID = testimonialSlider7.attr("id");

					var swiper = new Swiper(`#${sliderID}`, {
						slidesPerView: 1,
						spaceBetween: 20,
						centeredSlides: true,
						loop: loop,
						speed: 1500,
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
						...(nav
							? {
									navigation: {
										nextEl: ".slider-next",
										prevEl: ".slider-prev",
									},
							  }
							: {}),
						...(autoplay
							? {
									autoplay: {
										delay: delay,
										disableOnInteraction: true,
									},
							  }
							: {}),
						breakpoints: {
							576: {
								slidesPerView: 1.5,
							},
							768: {
								slidesPerView: 2,
							},
							1025: {
								slidesPerView: 2.2,
								spaceBetween: 30,
							},
							1201: {
								slidesPerView: 2.8,
								spaceBetween: 30,
							},
							1400: {
								slidesPerView: 4,
								spaceBetween: 30,
							},
						},
					});
				}
			}
		);

		// blog slider
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-latest-posts.default",

			function ($scope, $) {
				let wrap = $scope.find(".carouselWrap");

				let loop = wrap.attr("data-loop") == "yes" ? true : false;
				let nav = wrap.attr("data-nav") == "yes" ? true : false;
				let dot = wrap.attr("data-dot") == "yes" ? true : false;
				let autoplay = wrap.attr("data-autoplay") == "yes" ? true : false;
				let delay = wrap.attr("data-delay") ? wrap.attr("data-delay") : "5000";

				// slider one
				let blogSlider = $scope.find(".blog-slider");
				if (blogSlider.length > 0) {
					let sliderID = blogSlider.attr("id");
					var blogCarousel = new Swiper(`#${sliderID}`, {
						slidesPerView: 2,
						spaceBetween: 30,
						loop: loop,
						speed: 1500,

						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						...(nav
							? {
									navigation: {
										nextEl: ".slider-next",
										prevEl: ".slider-prev",
									},
							  }
							: {}),
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
						breakpoints: {
							0: {
								slidesPerView: 1,
								spaceBetween: 15,
							},
							576: {
								slidesPerView: 1,
								spaceBetween: 15,
							},
							768: {
								slidesPerView: 1,
								spaceBetween: 20,
							},
							1025: {
								slidesPerView: 2,
								spaceBetween: 20,
							},
							1201: {
								slidesPerView: 2,
							},
						},
					});
				}
			}
		);

		// marquee slider
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-marquee.default",

			function ($scope, $) {
				// slider one
				let marqueeSlider = $scope.find(".marquee-slider");
				if (marqueeSlider.length > 0) {
					let sliderID = marqueeSlider.attr("id");
					var marqueeCarousel = new Swiper(`#${sliderID}`, {
						slidesPerView: "auto",
						spaceBetween: 0,
						freemode: true,
						centeredSlides: true,
						loop: true,
						speed: 7000,
						allowTouchMove: false,
						autoplay: {
							delay: 1,
							disableOnInteraction: true,
						},
					});
				}

				// slider two
				let marquee2Slider = $scope.find(".h5-maquee-slider");
				if (marquee2Slider.length > 0) {
					let sliderID = marquee2Slider.attr("id");

					var swiper2 = new Swiper(`#${sliderID}`, {
						slidesPerView: "auto",
						spaceBetween: 30,
						loop: true,
						speed: 5000,
						breakpoints: {
							768: {
								spaceBetween: 35,
							},

							1025: {
								spaceBetween: 50,
							},
						},
						allowTouchMove: false,
						autoplay: {
							delay: 1,
							disableOnInteraction: true,
						},
					});
				}
			}
		);

		// tj-service-list
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-service-list.default",

			function ($scope, $) {
				if (typeof gsap !== "undefined" && typeof ScrollTrigger !== "undefined") {
					gsap.registerPlugin(ScrollTrigger);

					const serviceStack = $scope.find(".service-stack");

					if (serviceStack.length > 0 && window.innerWidth > 768) {
						serviceStack.each(function () {
							gsap.to(this, {
								opacity: 0,
								scale: 0.9,
								y: 50,
								scrollTrigger: {
									trigger: this,
									scrub: true,
									start: "top top",
									pin: true,
									pinSpacing: false,
									markers: false,
								},
							});
						});
					}
				}
			}
		);

		// tj-pricing-box
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-pricing-box.default",

			function ($scope, $) {
				let priceBox = $scope.find(".pricing-box");
				if (priceBox.length > 0) {
					var year = $(".yearly");
					var month = $(".monthly");

					var price = $(".price-number");
					var period = $(".period");

					year.on("click", function () {
						$(this).addClass("active");
						month.removeClass("active");
						price.each(function () {
							$(this).text($(this).data("year-price"));
						});
						period.each(function () {
							$(this).text($(this).data("year-period"));
						});
					});
					month.on("click", function () {
						$(this).addClass("active");
						year.removeClass("active");
						price.each(function () {
							$(this).text($(this).data("month-price"));
						});
						period.each(function () {
							$(this).text($(this).data("month-period"));
						});
					});
				}
			}
		);

		// tj project list
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-project-list.default",

			function ($scope, $) {
				function tjrtlValue(value) {
					const isRTL = document.documentElement.dir === "rtl";
					return isRTL ? -value : value;
				}

				// h5 project
				if ($(".tj-scroll-slider-item").length > 0) {
					let mediaMatch = gsap.matchMedia();
					mediaMatch.add("(min-width: 768px)", () => {
						const slider = document.querySelector(".tj-scroll-slider");
						if (slider?.children?.length) {
							let panels = gsap.utils.toArray(".tj-scroll-slider-item");
							gsap.to(panels, {
								xPercent: tjrtlValue(-100) * (panels.length - 1),
								ease: "none",
								scrollTrigger: {
									trigger: slider,
									start: "top+=50 top",
									pin: true,
									scrub: 1,
									end: () => "+=" + slider.offsetWidth,
								},
							});
						}
					});
				}

				// h6 project
				const $projectItems = $scope.find(".h6-project-item");

				if ($projectItems.length) {
					$projectItems.on("mouseenter", function () {
						const $currentItem = $(this);
						$currentItem.addClass("active").siblings(".h6-project-item").removeClass("active");
					});
				}

				// h7 project
				if ($(".tj-sticky-panel").length > 0) {
					let mediaMatch = gsap.matchMedia();
					mediaMatch.add("(min-width: 1200px)", () => {
						let tl = gsap.timeline();
						let panels = document.querySelectorAll(".tj-sticky-panel");
						panels.forEach((panel, i) => {
							tl.to(panel, {
								scrollTrigger: {
									trigger: panel,
									pin: panel,
									scrub: 1,
									start: "top-=50 top",
									end: "bottom top",
									endTrigger: ".tj-sticky-panel-container",
									pinSpacing: false,
									markers: false,
								},
							});
						});
					});
				}
			}
		);

		// tj video info
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-video-info.default",

			function ($scope, $) {
				let wrap = $scope.find(".carouselWrap");

				let loop = wrap.attr("data-loop") == "yes" ? true : false;
				let dot = wrap.attr("data-dot") == "yes" ? true : false;
				let autoplay = wrap.attr("data-autoplay") == "yes" ? true : false;
				let delay = wrap.attr("data-delay") ? wrap.attr("data-delay") : "5000";

				let videoSlider = $scope.find(".h6-hero-card-slider");

				if (videoSlider.length > 0) {
					let sliderID = videoSlider.attr("id");
					var videoCarousel = new Swiper(`#${sliderID}`, {
						slidesPerView: 1,
						spaceBetween: 15,
						loop: loop,
						speed: 1500,
						...(autoplay
							? {
									autoplay: {
										delay: delay,
									},
							  }
							: {}),
						...(dot
							? {
									pagination: {
										el: ".swiper-pagination-area",
										clickable: true,
									},
							  }
							: {}),
					});
				}
			}
		);

		// tj-achievement
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-achievement.default",

			function ($scope, $) {
				let awardWrapper = $scope.find(".tj-active-bg-wrapper");

				if (awardWrapper.length > 0) {
					function hoverWidget_animation() {
						let active_bg = $(".tj-active-bg-wrapper .active-bg");
						let element = $(".tj-active-bg-wrapper .current");
						$(".tj-active-bg-wrapper .tj-active-bg-item").on("mouseenter", function () {
							let e = $(this);
							activeHover(active_bg, e);
						});
						$(".tj-active-bg-wrapper").on("mouseleave", function () {
							element = $(".tj-active-bg-wrapper .current");
							activeHover(active_bg, element);
							element.closest(".tj-active-bg-item").siblings().removeClass("mleave");
						});
						activeHover(active_bg, element);
						function activeHover(active_bg, e) {
							if (!e.length) {
								return false;
							}
							let topOff = e.offset().top;
							let height = e.outerHeight();
							let menuTop = $(".tj-active-bg-wrapper").offset().top;
							e.closest(".tj-active-bg-item").removeClass("mleave");
							e.closest(".tj-active-bg-item").siblings().addClass("mleave");
							active_bg.css({
								top: topOff - menuTop + "px",
								height: height + "px",
							});
						}

						$(".tj-active-bg-wrapper .tj-active-bg-item").on("click", function () {
							$(".tj-active-bg-wrapper .tj-active-bg-item").removeClass("current");
							$(this).addClass("current");
						});
					}
					hoverWidget_animation();
				}
			}
		);

		// tj process
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-process.default",

			function ($scope, $) {
				// h6 process
				const hoverItems = $scope.find(".tj-hover-active-item");
				if (hoverItems.length) {
					hoverItems.each(function () {
						$(this).on("mouseenter", function () {
							hoverItems.removeClass("active");
							$(this).addClass("active");
						});
					});
				}
			}
		);

		// tj-team-carousel
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-team-carousel.default",

			function ($scope, $) {
				let wrap = $scope.find(".carouselWrap");

				let loop = wrap.attr("data-loop") == "yes" ? true : false;
				let autoplay = wrap.attr("data-autoplay") == "yes" ? true : false;
				let delay = wrap.attr("data-delay") ? wrap.attr("data-delay") : "1";

				// slider one
				let marqueeSlider = $scope.find(".h7-team-marquee");
				if (marqueeSlider.length > 0) {
					let sliderID = marqueeSlider.attr("id");

					var marquee = new Swiper(`#${sliderID}`, {
						slidesPerView: "auto",
						spaceBetween: 10,
						freemode: true,
						centeredSlides: true,
						loop: loop,
						speed: 7000,
						allowTouchMove: false,
						...(autoplay
							? {
									autoplay: {
										delay: delay,
										disableOnInteraction: true,
									},
							  }
							: {}),
						breakpoints: {
							1025: {
								spaceBetween: 15,
							},
						},
					});
				}
			}
		);

		// tj-review
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-review.default",

			function ($scope, $) {
				let starRating = $scope.find(".star-ratings");
				if (starRating.length > 0) {
					// rating
					if ($(".fill-ratings span").length > 0) {
						var star_rating_width = $(".fill-ratings span").width();
						$(".star-ratings").width(star_rating_width);
					}
				}
			}
		);

		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tj-progress-bar.default",

			function ($scope, $) {
				const progressBarController = () => {
					const progressContainers = document.querySelectorAll(".tj-progress");

					if (progressContainers?.length) {
						progressContainers.forEach(progressContainer => {
							const targetedProgressBar = progressContainer.querySelector(".tj-progress-bar");
							const completedPercent = parseInt(targetedProgressBar.getAttribute("data-percent", 10)) || 0;

							const observer = new IntersectionObserver(
								entries => {
									entries.forEach(entry => {
										if (entry.isIntersecting) {
											targetedProgressBar.style.transition = "width 2s ease-out";
											targetedProgressBar.style.width = `${completedPercent}%`;
											const percentageText = progressContainer.querySelector(".tj-progress-percent");
											if (percentageText) {
												let currentPercent = 0;
												const interval = setInterval(() => {
													currentPercent++;
													percentageText.textContent = `${currentPercent}%`;
													if (currentPercent >= completedPercent) {
														clearInterval(interval);
													}
												}, 15);
											}
										}
									});
								},
								{
									root: null,
									threshold: [0.3, 0.9],
								}
							);
							observer.observe(progressContainer);
						});
					}
				};
				progressBarController();

				if (typeof $.fn.knob != "undefined") {
					$(".knob").each(function () {
						var $this = $(this),
							knobVal = $this.attr("data-rel");
						$this.knob({
							draw: function () {
								$(this.i).val(this.cv + "%");
							},
						});
						new Waypoint({
							element: $this[0],
							handler: function () {
								$({value: 0}).animate(
									{
										value: knobVal,
									},
									{
										duration: 2000,
										easing: "swing",
										step: function () {
											$this.val(Math.ceil(this.value)).trigger("change");
										},
									}
								);
							},
							offset: "bottom-in-view",
						});
					});
				}
			}
		);
	});
})(jQuery);
