<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 2.3
 */

$rdtheme_socials = RDTheme_Helper::socials();
$nav_menu_args   = RDTheme_Helper::nav_menu_args();
// Icon count
$rdtheme_icon_count = 0;
if ( RDTheme::$options['search_icon'] ) {
	$rdtheme_icon_count++;
}
if ( RDTheme::$options['cart_icon'] && class_exists( 'WC_Widget_Cart' ) ) {
	$rdtheme_icon_count++;
}
if ( RDTheme::$options['vertical_menu_icon'] && has_nav_menu( 'topright' ) ) {
	$rdtheme_icon_count++;
}
?>
<div class="container masthead-container">
	<div class="row header-firstrow-wrap">
		<div class="col-sm-4 col-xs-12">
			<div class="header-firstrow">
				<div class="header-firstrow-contents">
					<ul class="header-contact">
						<?php if ( RDTheme::$options['phone'] ): ?>
							<li>
								<i class="fas fa-phone-alt" aria-hidden="true"></i><a href="tel:<?php echo esc_attr( RDTheme::$options['phone'] );?>"><?php echo esc_html( RDTheme::$options['phone'] );?></a>
							</li>
						<?php endif; ?>
						<?php if ( RDTheme::$options['email'] ): ?>
							<li>
								<i class="far fa-envelope" aria-hidden="true"></i><a href="mailto:<?php echo esc_attr( RDTheme::$options['email'] );?>"><?php echo esc_html( RDTheme::$options['email'] );?></a>
							</li>
						<?php endif; ?>
					</ul>
				</div>
			</div>
		</div>
		<div class="col-sm-4 col-xs-12">
			<div class="site-branding">
				<?php echo RDTheme_Helper::get_site_logo(); ?>
			</div>
		</div>
		<div class="col-sm-4 col-xs-12">
			<div class="header-firstrow">
				<div class="header-firstrow-contents header-firstrow-contents-right">
					<?php if ( $rdtheme_socials ): ?>
						<ul class="header-social">
							<?php foreach ( $rdtheme_socials as $rdtheme_social ): ?>
								<li><a target="_blank" href="<?php echo esc_url( $rdtheme_social['url'] );?>"><i class="<?php echo esc_attr( $rdtheme_social['icon'] );?>"></i></a></li>
							<?php endforeach; ?>					
						</ul>						
					<?php endif; ?>
					<?php if ( $rdtheme_icon_count ): ?>
						<?php get_template_part( 'template-parts/header/icon', 'area' );?>
					<?php endif; ?>		
				</div>
			</div>
		</div>
	</div>
	<hr class="menu-sep" />
	<div id="site-navigation" class="main-navigation">
		<?php wp_nav_menu( $nav_menu_args );?>
	</div>
</div>