/*!
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2025 Teclib' and contributors.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */
"use strict";(self["webpackChunk_glpi_glpi"]=self["webpackChunk_glpi_glpi"]||[]).push([[2],{33:(e,t,n)=>{n.r(t);n.d(t,{default:()=>a});var l=n(34);var s=n(36);var d=n(38);var r=n(27);const i=(0,r["default"])(s["default"],[["render",l.render],["__scopeId","data-v-41c46d64"],["__file","js/src/vue/CustomObject/FieldPreview/Sidebar.vue"]]);if(false){}const a=i},34:(e,t,n)=>{n.r(t);n.d(t,{render:()=>l.render});var l=n(35)},35:(e,t,n)=>{n.r(t);n.d(t,{render:()=>u});var l=n(9);const s={class:"h-100 d-flex col-auto flex-column p-2 px-3 fields-sidebar"};const d={class:"fs-2"};const r=["placeholder"];const i={key:0,class:"fs-3"};const a={class:"fs-3 mt-3"};const o={class:"align-items-center col-12"};const c={class:"form-field row flex-grow-1 mx-0 my-1 new-custom-field cursor-pointer btn btn-sm btn-ghost-secondary w-100",role:"button"};const f={class:"col py-2 text-center"};function u(e,t,n,u,_,p){return(0,l.openBlock)(),(0,l.createElementBlock)("div",s,[(0,l.createElementVNode)("span",d,(0,l.toDisplayString)(e.__("Add more fields")),1),(0,l.withDirectives)((0,l.createElementVNode)("input",{type:"text",class:"form-control mb-3",name:"search",placeholder:e.__("Search"),"onUpdate:modelValue":t[0]||(t[0]=e=>u.search=e)},null,8,r),[[l.vModelText,u.search]]),u.unused_native_fields.size>0?((0,l.openBlock)(),(0,l.createElementBlock)("span",i,(0,l.toDisplayString)(e.__("Native fields")),1)):(0,l.createCommentVNode)("v-if",true),((0,l.openBlock)(true),(0,l.createElementBlock)(l.Fragment,null,(0,l.renderList)(u.getMatched(u.unused_native_fields),([e,t])=>((0,l.openBlock)(),(0,l.createBlock)(u["Field"],{key:e,field_key:e,is_active:false},{field_label:(0,l.withCtx)(()=>[(0,l.createTextVNode)((0,l.toDisplayString)(t.label),1)]),_:2},1032,["field_key"]))),128)),(0,l.createElementVNode)("span",a,(0,l.toDisplayString)(e.__("Custom fields")),1),((0,l.openBlock)(true),(0,l.createElementBlock)(l.Fragment,null,(0,l.renderList)(u.getMatched(u.unused_custom_fields),([e,t])=>((0,l.openBlock)(),(0,l.createBlock)(u["Field"],{key:e,field_key:e,is_active:false,customfields_id:t.customfields_id},{field_label:(0,l.withCtx)(()=>[(0,l.createTextVNode)((0,l.toDisplayString)(t.label),1)]),_:2},1032,["field_key","customfields_id"]))),128)),(0,l.createElementVNode)("div",o,[(0,l.createElementVNode)("div",c,[(0,l.createElementVNode)("div",f,[t[1]||(t[1]=(0,l.createElementVNode)("i",{class:"ti ti-plus"},null,-1)),(0,l.createTextVNode)(" "+(0,l.toDisplayString)(e.__("New field")),1)])])])])}},36:(e,t,n)=>{n.r(t);n.d(t,{default:()=>l["default"]});var l=n(37)},37:(e,t,n)=>{n.r(t);n.d(t,{default:()=>d});var l=n(11);var s=n(9);const d={__name:"Sidebar",props:{inactive_fields:Map,add_edit_fn:String},setup(e,{expose:t}){t();const n=e;const d=(0,s.ref)("");const r=(0,s.computed)(()=>new Map([...n.inactive_fields].filter(([e,t])=>(t.customfields_id??-1)<0)));const i=(0,s.computed)(()=>new Map([...n.inactive_fields].filter(([e,t])=>(t.customfields_id??-1)>=0)));function a(e){if(d.value===""){return e}const t=new Map;for(const[n,l]of e){if(l.label.toLowerCase().includes(d.value.toLowerCase())){t.set(n,l)}}return t}(0,s.onMounted)(()=>{$(".fields-sidebar .new-custom-field").on("click",()=>{window[n.add_edit_fn](-1)})});const o={props:n,search:d,unused_native_fields:r,unused_custom_fields:i,getMatched:a,Field:l["default"],computed:s.computed,ref:s.ref,onMounted:s.onMounted};Object.defineProperty(o,"__isScriptSetup",{enumerable:false,value:true});return o}}},38:(e,t,n)=>{n.r(t);var l=n(39)},39:(e,t,n)=>{n.r(t);n.d(t,{default:()=>w});var l=n(18);var s=n.n(l);var d=n(19);var r=n.n(d);var i=n(20);var a=n.n(i);var o=n(21);var c=n.n(o);var f=n(22);var u=n.n(f);var _=n(23);var p=n.n(_);var v=n(40);var m={};m.styleTagTransform=p();m.setAttributes=c();m.insert=a().bind(null,"head");m.domAPI=r();m.insertStyleElement=u();var b=s()(v["default"],m);const w=v["default"]&&v["default"].locals?v["default"].locals:undefined},40:(e,t,n)=>{n.r(t);n.d(t,{default:()=>a});var l=n(25);var s=n.n(l);var d=n(26);var r=n.n(d);var i=r()(s());i.push([e.id,`\n.fields-sidebar {\n&[data-v-41c46d64] {\n        border-left: 1px solid var(--tblr-border-color);\n        width: 300px;\n}\n.sortable-field.col-sm-6[data-v-41c46d64] {\n            width: 100%;\n}\n.form-field.new-custom-field[data-v-41c46d64] {\n            border: var(--tblr-border-width) dashed var(--tblr-border-color);\n            border-radius: var(--tblr-border-radius);\n}\n}\n`,"",{version:3,sources:["webpack://./js/src/vue/CustomObject/FieldPreview/Sidebar.vue","<no source>"],names:[],mappings:";AAiEI;ACjEJ;QDkEQ,+CAA+C;QAC/C,YAAA;AA9DR;AA+DQ;YACI,WAAW;AACf;AACA;YACI,gEAAgE;YAChE,wCAAwC;AAC5C;AACJ",sourcesContent:['<script setup>\n    import Field from "./Field.vue";\n    import {computed, ref, onMounted} from "vue";\n\n    const props = defineProps({\n        inactive_fields: Map,\n        add_edit_fn: String,\n    });\n\n    const search = ref(\'\');\n\n    const unused_native_fields = computed(() => {\n        return new Map([...props.inactive_fields].filter(([key, field]) => (field.customfields_id ?? -1) < 0));\n    });\n    const unused_custom_fields = computed(() => {\n        return new Map([...props.inactive_fields].filter(([key, field]) => (field.customfields_id ?? -1) >= 0));\n    });\n\n    function getMatched(fields) {\n        if (search.value === \'\') {\n            return fields;\n        }\n        const results = new Map();\n        for (const [key, field] of fields) {\n            if (field.label.toLowerCase().includes(search.value.toLowerCase())) {\n                results.set(key, field);\n            }\n        }\n        return results;\n    }\n\n    onMounted(() => {\n        $(\'.fields-sidebar .new-custom-field\').on(\'click\', () => {\n            window[props.add_edit_fn](-1);\n        });\n    });\n\n<\/script>\n\n<template>\n    <div class="h-100 d-flex col-auto flex-column p-2 px-3 fields-sidebar">\n        <span class="fs-2">{{ __(\'Add more fields\') }}</span>\n        <input type="text" class="form-control mb-3" name="search" :placeholder="__(\'Search\')" v-model="search" />\n        <span v-if="unused_native_fields.size > 0" class="fs-3">{{ __(\'Native fields\') }}</span>\n        <Field v-for="[field_key, unused_field] of getMatched(unused_native_fields)" :key="field_key" :field_key="field_key"\n               :is_active="false">\n            <template v-slot:field_label>{{ unused_field.label }}</template>\n        </Field>\n        <span class="fs-3 mt-3">{{ __(\'Custom fields\') }}</span>\n        <Field v-for="[field_key, unused_field] of getMatched(unused_custom_fields)" :key="field_key" :field_key="field_key"\n               :is_active="false" :customfields_id="unused_field.customfields_id">\n            <template v-slot:field_label>{{ unused_field.label }}</template>\n        </Field>\n        <div class="align-items-center col-12">\n            <div class="form-field row flex-grow-1 mx-0 my-1 new-custom-field cursor-pointer btn btn-sm btn-ghost-secondary w-100" role="button">\n                <div class="col py-2 text-center">\n                    <i class="ti ti-plus"></i>\n                    {{ __(\'New field\') }}\n                </div>\n            </div>\n        </div>\n    </div>\n</template>\n\n<style scoped>\n    .fields-sidebar {\n        border-left: 1px solid var(--tblr-border-color);\n        width: 300px;\n        .sortable-field.col-sm-6 {\n            width: 100%;\n        }\n        .form-field.new-custom-field {\n            border: var(--tblr-border-width) dashed var(--tblr-border-color);\n            border-radius: var(--tblr-border-radius);\n        }\n    }\n</style>\n',null],sourceRoot:""}]);const a=i}}]);