<?php
/**
 * @Top Recruiters widget Class
 *
 */
if (!class_exists('top_recruiters')) {

    class top_recruiters extends WP_Widget {

        /**
         * Start Function how to create Top Recruiters Module
         *        
         */
        public function __construct() {
            parent::__construct(
                    'top_recruiters', // Base ID
                    esc_html__('CS : Top Recruiters', 'jobhunt'), // Name
                    array('classname' => 'cs-top-recruiters', 'description' => esc_html__('Display number of Top Recruiters.', 'jobhunt'),)
            );
        }

        /**
         * Start Function how to create Top Recruiters html form
         *        
         */
        function form($instance) {
            global $cs_html_fields, $cs_theme_html_fields;
            $instance = wp_parse_args((array) $instance, array('title' => ''));
            $title = $instance['title'];
            $total_num = isset($instance['total_num']) ? esc_attr($instance['total_num']) : '';
            $recruiter_style = isset($instance['recruiter_style']) ? esc_attr($instance['recruiter_style']) : '';

            $cs_opt_array = array(
                'name' => esc_html__('Title', 'jobhunt'),
                'desc' => '',
                'hint_text' => '',
                'echo' => true,
                'field_params' => array(
                    'std' => esc_attr($title),
                    'id' => cs_allow_special_char($this->get_field_id('title')),
                    'classes' => '',
                    'cust_id' => cs_allow_special_char($this->get_field_name('title')),
                    'cust_name' => cs_allow_special_char($this->get_field_name('title')),
                    'return' => true,
                    'required' => false
                ),
            );
            echo force_balance_tags($cs_html_fields->cs_text_field($cs_opt_array));


            $cs_opt_array = array(
                'name' => esc_html__('Total Numbers', 'jobhunt'),
                'desc' => '',
                'hint_text' => '',
                'echo' => true,
                'field_params' => array(
                    'std' => esc_attr($total_num),
                    'id' => cs_allow_special_char($this->get_field_id('total_num')),
                    'classes' => '',
                    'cust_id' => cs_allow_special_char($this->get_field_name('total_num')),
                    'cust_name' => cs_allow_special_char($this->get_field_name('total_num')),
                    'return' => true,
                    'required' => false
                ),
            );
            force_balance_tags($cs_html_fields->cs_text_field($cs_opt_array));

            $cs_opt_array = array(
                'name' => esc_html__('Recruiters Style', 'jobhunt'),
                'desc' => '',
                'hint_text' => '',
                'extra' => '',
                'echo' => true,
                'field_params' => array(
                    'std' => esc_attr($recruiter_style),
                    'id' => cs_allow_special_char($this->get_field_id('recruiter_style')),
                    'cust_name' => jobcareer_special_char($this->get_field_name('recruiter_style')),
                    'options' => array(
                        'default' => esc_html__('Default', 'jobhunt'),
                        'slider' => esc_html__('Slider', 'jobhunt'),
                        'modern' => esc_html__('Modern', 'jobhunt'),
                    ),
                    'return' => true,
                ),
            );

            force_balance_tags($cs_html_fields->cs_select_field($cs_opt_array));
        }

        /**
         * Start Function how to Top Recruiters update form data
         *        
         */
        function update($new_instance, $old_instance) {
            $instance = $old_instance;
            $instance['title'] = $new_instance['title'];
            $instance['total_num'] = $new_instance['total_num'];
            $instance['recruiter_style'] = $new_instance['recruiter_style'];
            $instance['recruiter_style_modern'] = $new_instance['recruiter_style_modern'];
            return $instance;
        }

        /**
         * Start Function how to Display Top Recruiters widget
         *        
         */
        function widget($args, $instance) {
            global $cs_plugin_options;
            extract($args, EXTR_SKIP);
            $title = empty($instance['title']) ? '' : apply_filters('widget_title', $instance['title']);
            $total_num = isset($instance['total_num']) ? esc_attr($instance['total_num']) : '';
            $recruiter_style = empty($instance['recruiter_style']) ? ' ' : apply_filters('widget_title', $instance['recruiter_style']);
            $cs_emp_funs = new cs_employer_functions();
            echo CS_FUNCTIONS()->cs_special_chars($before_widget);
            if (!empty($title) && $title <> ' ') {
                echo CS_FUNCTIONS()->cs_special_chars($before_title);
                echo CS_FUNCTIONS()->cs_special_chars($title);
                echo CS_FUNCTIONS()->cs_special_chars($after_title);
            }
            if (!isset($total_num) || $total_num == '') {
                $total_num = 10;
            }
            $user_args = array(
                'role' => 'cs_employer',
                'orderby' => 'post_count',
                'order' => 'ASC',
                'number' => $total_num
            );
            $employers = get_users($user_args);
            $slider_class = '';
            if (isset($recruiter_style) && $recruiter_style == 'slider') {
                $slider_class = 'sidebar-slider';
            } elseif (isset($recruiter_style) && $recruiter_style == 'modern') {
                $slider_class = 'sidebar-modern';
            }
            echo ' <ul class="recruiter-list ' . $slider_class . '">';
            $rec_counter = 1;
            foreach ($employers as $emp) {
                if ($rec_counter > $total_num) {
                    break;
                }
                $cs_profile_img_name = get_user_meta($emp->ID, 'user_img', true);
                $cs_loc_contry = get_user_meta($emp->ID, 'cs_post_loc_country', true);
                $cs_loc_city = get_user_meta($emp->ID, 'cs_post_loc_city', true);
                $user_nicename = get_user_meta($emp->ID, 'nickname', true);

                $cs_user_img = '';
                $cs_user_img = cs_get_image_url($cs_profile_img_name, 'cs_media_5');
                if (!cs_image_exist($cs_user_img) || $cs_user_img == "") {
                    $cs_user_img = esc_url(wp_jobhunt::plugin_url() . 'assets/images/img-not-found16x9.jpg');
                }
                $cs_jobs_count = count_user_posts($emp->ID, 'jobs');
                ?>

                <?php
                if (isset($recruiter_style) && $recruiter_style == 'slider') {
                    ?>
                    <li>
                        <div class="cs-media">
                            <figure>
                                <a href="<?php echo esc_url(get_author_posts_url($emp->ID)); ?>"><img alt="" src="<?php echo esc_url($cs_user_img) ?>"></a>
                                <figcaption><span class="jobs-count"><?php echo absint($cs_jobs_count); ?></span> </figcaption> 
                            </figure>
                        </div>
                    </li>
                <?php } elseif (isset($recruiter_style) && $recruiter_style == 'modern') {
                    ?>
                    <li>
                        <div class="cs-media">
                            <figure>
                                <a href="<?php echo esc_url(get_author_posts_url($emp->ID)); ?>"><img alt="" src="<?php echo esc_url($cs_user_img) ?>"></a>
                            </figure>
                        </div>   
                        <div class="cs-info">
                            <h6><a href="<?php esc_url(get_author_posts_url($emp->ID)) ?>"><?php echo $user_nicename; ?></a></h6>
                            <span class="location"><?php echo esc_html($cs_loc_city) . ' ' . esc_html($cs_loc_contry) ?></span> 
                            <span class="jobs-count"><?php printf(esc_html__('%s Open Jobs', 'jobhunt'), absint($cs_jobs_count)) ?></span> 
                        </div>
                    </li>
                    <?php
                } else {

                    $cs_img_headers = get_headers($cs_user_img);
                    if (isset($cs_img_headers[0]) && strpos($cs_img_headers[0], '200') !== false) {
                        echo '<a href="' . esc_url(get_author_posts_url($emp->ID)) . '"><img alt="" src="' . esc_url($cs_user_img) . '" width="70"></a>';
                    } else {

                        echo '<a href="' . esc_url(get_author_posts_url($emp->ID)) . '"><img alt="" src="' . esc_url($cs_user_img) . '" width="70"></a>';
                    }
                    ?>
                    <div class="cs-info">
                        <h6><a href="<?php esc_url(get_author_posts_url($emp->ID)) ?>"><?php echo $user_nicename; ?></a></h6>
                        <?php if ($cs_loc_city != '' || $cs_loc_contry != '') { ?>
                            <span class="location"><i class="icon-location6"></i><?php echo esc_html($cs_loc_city) . ' ' . esc_html($cs_loc_contry) ?></span> 
                            <?php
                        }
                        ?>
                        <span class="jobs"><i class="icon-briefcase4"></i><?php printf(esc_html__('%s Jobs', 'jobhunt'), absint($cs_jobs_count)) ?></span> 

                    </div>
                    <?php
                    $rec_counter ++;
                }
            }
            echo '</ul>';


            echo CS_FUNCTIONS()->cs_special_chars($after_widget);
        }

    }

//add_action('widgets_init', create_function('', 'return register_widget("top_recruiters");'));
    add_action('widgets_init', function() {
        return register_widget("top_recruiters");
    });
}
