<?php
/**
 * Plugin Name: JobHunt Jobs Importer
 * Plugin URI: http://themeforest.net/user/Chimpstudio/
 * Description: Job Hunt Jobs Importer Add on
 * Version: 1.2
 * Author: ChimpStudio
 * Author URI: http://themeforest.net/user/Chimpstudio/
 * @package Job Hunt
 * Text Domain: jobhunt-jobs-importer
 */
// Direct access not allowed.
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Job_Hunt_Jobs_Importer_Import class.
 */
class Job_Hunt_Jobs_Importer {

    public $admin_notices;

    /**
     * construct function.
     */
    public function __construct() {

        // Define constants
        define('JOBHUNT_JOBS_IMPORTER_PLUGIN_VERSION', '1.2');
        define('JOBHUNT_JOBS_IMPORTER_PLUGIN_DOMAIN', 'jobhunt-jobs-importer');
        define('JOBHUNT_JOBS_IMPORTER_PLUGIN_URL', WP_PLUGIN_URL . '/jobhunt-jobs-importer');
        define('JOBHUNT_JOBS_IMPORTER_CORE_DIR', WP_PLUGIN_DIR . '/jobhunt-jobs-importer');
        define('JOBHUNT_JOBS_IMPORTER_LANGUAGES_DIR', JOBHUNT_JOBS_IMPORTER_CORE_DIR . '/languages');
        define('JOBHUNT_JOBS_IMPORTER_INCLUDES_DIR', JOBHUNT_JOBS_IMPORTER_CORE_DIR . '/includes');
        $this->admin_notices = array();
        //admin notices
        add_action('admin_notices', array($this, 'job_jobs_importer_notices_callback'));
        if (!$this->check_dependencies()) {
            return false;
        }

        // Initialize Addon
        add_action('init', array($this, 'init'));
    }

    /**
     * Initialize application, load text domain, enqueue scripts, include classes and add actions
     */
    public function init() {
        // Add Plugin textdomain
        $locale = apply_filters('plugin_locale', get_locale(), 'jobhunt-jobs-importer');
        load_textdomain('jobhunt-jobs-importer', JOBHUNT_JOBS_IMPORTER_LANGUAGES_DIR . '/jobhunt-jobs-importer' . "-" . $locale . '.mo');
        load_plugin_textdomain('jobhunt-jobs-importer', false, JOBHUNT_JOBS_IMPORTER_LANGUAGES_DIR);

        // Enqueue CSS
        wp_enqueue_style('jobhunt-jobs-importer-styles', esc_url(JOBHUNT_JOBS_IMPORTER_PLUGIN_URL . '/assets/css/jobhunt-jobs-importer-style.css'));
        // Enqueue JS
        wp_enqueue_script('jobhunt-jobs-importer-script', esc_url(JOBHUNT_JOBS_IMPORTER_PLUGIN_URL . '/assets/js/jobhunt-jobs-importer-function.js'), '', 'jobhunt-jobs-importer', true);
        $jobhunt_functions_string = array(
            'ajax_url' => admin_url('admin-ajax.php'),
        );
        wp_localize_script('jobhunt-jobs-importer-script', 'jobhunt_globals', $jobhunt_functions_string);

        require_once ( JOBHUNT_JOBS_IMPORTER_INCLUDES_DIR . '/class-jobhunt-jobs-export.php' );
        require_once ( JOBHUNT_JOBS_IMPORTER_INCLUDES_DIR . '/class-jobhunt-jobs-import.php' );

        // Add actions
        add_action('admin_menu', array(&$this, 'jobhunt_jobs_importer_import_page'));
        add_action('wp_ajax_jobhunt_import_jobs_importer', array(&$this, 'jobhunt_import_jobs_importer'));
    }

    /**
     * Check plugin dependencies (JobHunt), nag if missing.
     *
     * @param boolean $disable disable the plugin if true, defaults to false.
     */
    public function check_dependencies($disable = false) {
        $result = true;
        $active_plugins = get_option('active_plugins', array());
        if (is_multisite()) {
            $active_sitewide_plugins = get_site_option('active_sitewide_plugins', array());
            $active_sitewide_plugins = array_keys($active_sitewide_plugins);
            $active_plugins = array_merge($active_plugins, $active_sitewide_plugins);
        }
        $jobhunt_is_active = in_array('wp-jobhunt/wp-jobhunt.php', $active_plugins);
        if (!$jobhunt_is_active) {
            $this->admin_notices = '<div class="error">' . __('<em><b>Job Hunt Jobs Importer</b></em> needs the <b>Job Hunt</b> plugin. Please install and activate it.', 'jobhunt-jobs-importer') . '</div>';
        }
        if (!$jobhunt_is_active) {
            if ($disable) {
                include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
                deactivate_plugins(array(__FILE__));
            }
            $result = false;
        }
        return $result;
    }

    public function job_jobs_importer_notices_callback() {
        if (isset($this->admin_notices) && !empty($this->admin_notices)) {
            foreach ($this->admin_notices as $value) {
                echo $value;
            }
        }
    }


    /**
     * Add import  admin menu page 
     * */
    public function jobhunt_jobs_importer_import_page() {
        add_submenu_page('edit.php?post_type=jobs', esc_html__('Jobs Importer', 'jobhunt-jobs-importer'), esc_html__('Jobs Importer', 'jobhunt-jobs-importer'), 'manage_options', 'jobhunt-jobs-importer', array(&$this, 'jobhunt_jobs_importer_settings'));
    }

    /**
     * Indeed jobs settings page
     * */
    public function jobhunt_jobs_importer_settings() {
        global $cs_html_fields, $jobcareer_form_fields, $cs_form_fields2;
        ?>
        <div id="wrapper" class="wrap theme-wrap custom-bg-color">
            <h2><?php echo esc_html__('Import / Export Jobs', 'jobhunt-jobs-importer'); ?></h2>
            <p style="padding: 10px 30px;">
                <?php echo esc_html__('Greetings! Upload your jobs feed RSS (XML) file and it will import all the jobs including title, slug, description, locations, status, custom fields, specialisms and so on.. Click on generate job xml to download a sample xml file of available jobs.', 'jobhunt-jobs-importer'); ?>

                <br><?php echo esc_html__('Choose a (.xml) file to upload, then click Upload file and import. Done Importing!', 'jobhunt-jobs-importer'); ?>
                </p>

            <div class="jobs-import-area" style="padding:50px 0 150px 50px;">

                <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12 jobhunt-import-export-box">
                    <form id="jobhunt-import-jobs-xml-render" class="jobhunt-import-jobs-xml-render" method="post" action="" enctype="multipart/form-data">
                        <input type="file" name="jobs_import_file" id="jobs_import_file" style="display: none;">
                        <div class="jobhunt-import-jobs-file">
                            <a href="javascript:;">
                                <i class="icon-upload5"></i>
                                <?php echo esc_html__('Import Jobs XML', 'jobhunt-jobs-importer'); ?>           
                            </a>
                        </div>
                    </form>
                </div>
                <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12 jobhunt-import-export-box">
                    <div class="jobhunt-export-jobs">
                        
                        <a href="javascript:;">
                                <i class="icon-export"></i>
                                <?php echo esc_html__('Generate Jobs XML', 'jobhunt-jobs-importer'); ?>       
                            </a>
                        
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
   

}

new Job_Hunt_Jobs_Importer();
