<?php

/**
 * Importing Email Templates Data
 *
 * @since 1.0
 * @package	Directory
 */
// Direct access not allowed.
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Email Templates Data Class.
 */
class Jobhunt_Email_Templates_Data {

    /**
     * Put hooks in place and activate.
     */
    public function __construct() {
        add_action('init', array($this, 'init'), 8);
    }

    public function init() {
        
        //do_action('jobhunt_email_verification_email', $reg_user);
        
        
        if( isset( $_GET['email_verify'] ) && $_GET['email_verify'] != '' ){
            $email_verify = $_GET['email_verify'];
            $email_verify = base64_decode(base64_decode($email_verify));
            $email_verify = json_decode($email_verify);
            //pre($email_verify);
            $user_id = isset( $email_verify->user_id )? $email_verify->user_id : 0;
            $verfication_code = isset( $email_verify->verfication_code )? $email_verify->verfication_code : 0;
            $user_verification_code = get_user_meta($user_id, 'verification_code', true);
            if( $verfication_code == $user_verification_code){
                //update_user_meta($user_id, 'verification_code', '');
                update_user_meta($user_id, 'email_verified', 1);
            }
            wp_redirect(site_url().'?email_verified=confirm');
            exit;
        }
        
        delete_option('templates_already_created');
        if (true != get_option('templates_already_created')) {
            add_action('jobhunt_load_email_templates', array($this, 'jobhunt_load_email_templates_data'));
        }
    }

    public function jobhunt_load_email_templates_data($email_templates) {
        if (!empty($email_templates)) {

            foreach ($email_templates as $group => $group_array) {
                $group_id = $this->jobhunt_register_email_group($group);
                $this->jobhunt_add_email_template_post($group_array, $group_id);
            }
            update_option('templates_already_created', true);
        }
    }

    public function jobhunt_register_email_group($group_slug) {
        $group_name = str_replace("_", " ", $group_slug);
        $group_id = 0;

        $return_data = wp_insert_term(
                $group_name, // the term 
                'email_template_group', // the taxonomy
                array(
                    'slug' => $group_name,
                )
        );
        if ((!isset($return_data->error_data)) && isset($return_data['term_id']) && $return_data['term_id'] != '') {
            $group_id = $return_data['term_id'];
        } else {
            if (isset($return_data->error_data)) {

                $group_id = $return_data->error_data['term_exists'];
            }
        }
        return $group_id;
    }

    public function jobhunt_add_email_template_post($group_array, $group_id) {
        global $wpdb;

        foreach ($group_array as $slug => $post_data) {
            $check = jobhunt_check_if_template_exists($slug, 'jh-templates');
            if (false == $check) {
                $new_template = array(
                    'post_title' => wp_strip_all_tags($post_data['title']),
                    'post_name' => $slug,
                    'post_content' => $post_data['template'],
                    'post_type' => 'jh-templates',
                    'post_status' => 'publish',
                    'post_author' => get_current_user_id(),
                );
                $post_id = wp_insert_post($new_template);
                update_post_meta($post_id, 'jh_email_template_type', $post_data['email_template_type']);
                update_post_meta($post_id, 'jh_email_notification', 1);
                $output = wp_set_object_terms($post_id, $group_id, 'email_template_group');

                update_post_meta($post_id, 'jh_email_type', $post_data['jh_email_type']);
                update_post_meta($post_id, 'is_recipients_enabled', $post_data['is_recipients_enabled']);
                update_post_meta($post_id, 'description', $post_data['description']);
            }
        }
    }

}

$jobhunt_email_templates_data_instance = new Jobhunt_Email_Templates_Data();