<?php $enrolments = $this->user_model->my_certificates()->result_array(); ?>
<?php $user_details = $this->user_model->get_all_user($this->session->userdata('user_id'))->row_array(); ?>
<style>
    html, body {
        background: #F5F9FA;
    }

    .container-fluid {
        background: #F5F9FA;
    }

    a:visited {
        color: white; /* Change this to your desired color */
    }
</style>
<div style="font-size: 21px; margin-left: 20px; margin-top: 8px;"><?php echo get_phrase('My Certificates'); ?></div>

<!-------- Certificate display section start ------>
<div style="margin-top: 20px; margin-left: 20px; margin-right: 20px; margin-bottom: 20px;" class="col-lg-9 col-md-8 col-sm-12">
    <div style="background: white; border-radius: 20px;" class="row">
    <?php foreach ($enrolments as $enrolment) :
        $course_details = $this->crud_model->get_course_by_id($enrolment['course_id'])->row_array();
        $instructor_details = $this->user_model->get_all_user($course_details['creator'])->row_array();
        $course_duration = $this->crud_model->get_total_duration_of_lesson_by_course_id($course_details['id']);
        $lectures = $this->db->get_where('lesson', ['course_id' => $course_details['id'], 'lesson_type !=' => 'quiz']);
        $quizzes = $this->db->get_where('lesson', ['course_id' => $course_details['id'], 'lesson_type' => 'quiz']);
        $watch_history = $this->crud_model->get_watch_histories($this->session->userdata('user_id'), $course_details['id'])->row_array();
        $course_progress = isset($watch_history['course_progress']) ? $watch_history['course_progress'] : 0;
    
        // Assuming $course_details has the correct issued_date
        $issued_date = $course_details['issued_date'];

        // Get the payment status from the enrolment
        $payment_status = $enrolment['payment_status'];

        // Exception handling and query
        try {
            $certificate_query = "SELECT shareable_url, status FROM certificates WHERE student_id = ? AND course_id = ?";
            $student_id = $this->session->userdata('user_id');
            $course_id = $course_details['id'];

            $certificate_result = $this->db->query($certificate_query, array($student_id, $course_id));

            if ($certificate_result) {
                $certificate_row = $certificate_result->row_array();
                $shareable_url = isset($certificate_row['shareable_url']) ? $certificate_row['shareable_url'] : '';
                $status = isset($certificate_row['status']) ? $certificate_row['status'] : 0;

                if ($status == 1 && $payment_status == 1) :
                    ?>
                    <!-- Display approved certificate -->
                    <div class="col-lg-12 col-md-12 col-sm-6 col-12 mb-5">
                        <div class="my-course-1-full-body-card">
                            <div class="my-course-1-text pt-1" style="padding: 10px;">
                                <div class="my-course-1-text-heading">
                                    <h6 style="padding-top: 18px;color:#001A45;"><?php echo $course_details['title']; ?></h6>
                                </div>
                                <div class="my-course-1-last">
                                    <span class="text-12px text-end mt-2"><?php echo get_phrase('Issued On') ?> - <b><?php echo date('d M Y', strtotime($issued_date)); ?></b></span>
                                </div>

                                <div class="my-course-1-last">
                                    <?php if ($enrolment['issued_date'] > 0 && $enrolment['issued_date'] < time()) : ?>
                                        <span class="text-12px text-end mt-2"><?php echo get_phrase('Expired') ?> - <b style="color: var(--bs-code-color);"><?php echo date('d M Y', $enrolment['expiry_date']); ?></b></span>
                                    <?php else : ?>
                                        <span class="text-12px text-end mt-2"><?php echo get_phrase('Expiration On') ?> - <b><?php echo date('d M Y', $enrolment['expiry_date']); ?></b></span>
                                    <?php endif; ?>
                                    <div class="my-course-1-btn pt-4 me-4">
                                        <?php if ($enrolment['expiry_date'] > 0 && $enrolment['expiry_date'] < time()) : ?>
                                            <a class="btn text-14px py-1 text-white"
                                               style="background-color: var(--bs-code-color);"
                                               href="#"
                                               onclick="actionTo('http://localhost/academy/academy_6.0/home/handle_buy_now/<?php echo $course_details['id']; ?>')">
                                                <i class="far fa-calendar-plus"></i>
                                                <?php echo get_phrase('Join again'); ?>
                                            </a>
                                        <?php else : ?>
                                            <a style="background:#007cff;margin-bottom:-30px;"
                                               class="btn btn-primary text-14px py-1"
                                               href="<?php echo base_url(); ?>certificate/<?php echo $shareable_url; ?>">
                                                <?php echo get_phrase('View Certificate'); ?>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div style="border:5px solid #F5F9FA;"></div>
                <?php elseif ($status == 0) : ?>
                    <!-- Display text message for rejected certificate -->
                    <div style="background:#F5F9FA;padding:4px;"></div>
                    <div class="col-lg-12 col-md-12 col-sm-6 col-12">
                        <div class="my-course-1-full-body-card">
                            <div class="my-course-1-text pt-1" style="padding: 10px;">
                                <div class="my-course-1-text-heading">
                                    <h6 style="padding-top: 18px;color:#001A45;"><?php echo $course_details['title']; ?></h6>
                                </div>
                                <div class="my-course-1-last">
                                    <span class="text-12px text-end mt-2"><?php echo get_phrase('Certificate Status') ?> - <b style="color:red;"><?php echo get_phrase('Rejected'); ?></b></span>
                                </div>
                                <div class="my-course-1-btn pt-4 me-4">
                                    <!-- Display the message for rejected certificates -->
                                    <p style="color:red;">Certificate is not eligible. Please contact the admin.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div style="border:5px solid #F5F9FA;"></div>
                <?php elseif ($payment_status != 1) : ?>
                    <!-- Display text message for unpaid courses -->
                    <div class="col-lg-12 col-md-12 col-sm-6 col-12">
                        <div class="my-course-1-full-body-card">
                            <div class="my-course-1-text pt-1" style="padding: 10px;">
                                <div class="my-course-1-text-heading">
                                    <h6 style="padding-top: 18px;color:#001A45;"><?php echo $course_details['title']; ?></h6>
                                </div>
                                <div class="my-course-1-last">
                                    <span class="text-12px text-end mt-2"><?php echo get_phrase('Payment Status') ?> - <b style="color:red;"><?php echo get_phrase('Not Paid'); ?></b></span>
                                </div>
                                <div class="my-course-1-btn pt-4 me-4">
                                    <!-- Display the message for unpaid courses -->
                                    <p style="color:red;">You need to make a payment to access this certificate. Please contact the admin for assistance.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div style="border:5px solid #F5F9FA;"></div>
                <?php endif;
            } else {
                echo "Query Error: " . $this->db->error(); // Output query error
                echo "Query: " . $this->db->last_query(); // Output the actual query
            }
        } catch (Exception $e) {
            echo "Exception: " . $e->getMessage(); // Output exception details
        }
    endforeach;
    ?>
    </div>
</div>