<?php
    $qr_code = 'uploads/certificates/qrcodes/'. $certificate_identifier.'.jpg';
    if(!file_exists($qr_code)){
        include APPPATH.'libraries/phpqrcode/qrlib.php';
        QRcode::png(site_url('certificate/'.$certificate_identifier), $qr_code, QR_ECLEVEL_L, 3, 4);
    }
?>

<!DOCTYPE html>
<html>
<head>
    <title><?php echo get_phrase('certificate'); ?> | <?php echo get_settings('system_title'); ?></title>
    <link rel="shortcut icon" href="<?php echo base_url('uploads/system/').get_frontend_settings('favicon');?>">
    <link href="<?php echo base_url('assets/backend/css/fontawesome-all.min.css') ?>" rel="stylesheet" type="text/css" />
    <script src="<?php echo base_url('assets/global/html2canvas/'); ?>html2canvas.min.js"></script>
    <script src="<?php echo base_url('assets/backend/js/jquery-3.3.1.min.js'); ?>" charset="utf-8"></script>

   <!--  <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.min.js" integrity="sha256-eTyxS0rkjpLEo16uXTS0uVCS4815lc40K2iVpWDvdSY=" crossorigin="anonymous"></script> -->
   <style type="text/css">
        @import url('https://fonts.googleapis.com/css2?family=Italianno&display=swap');
        @import url('https://fonts.googleapis.com/css2?family=Pinyon+Script&display=swap%27');
        @import url('https://fonts.googleapis.com/css2?family=Miss+Fajardose&display=swap%27');
        
        .download {
            padding: 12px 15px;
            background-color: #028A0F;
            border-radius: 5px;
            color: #fff;
            text-decoration: none;
            border: none;
            cursor: pointer;
            margin-top: 100px;
          }
   </style>
</head>

<body >
    <div id="capture" style="position: relative; width: 750px; margin-left: auto; margin-right: auto;">
    <?php

        $certificate = $this->db->get_where('certificates', array('shareable_url' => $certificate_identifier))->row_array();
        $course = $this->crud_model->get_course_by_id($certificate['course_id'])->row_array();
        $student_row = $this->user_model->get_all_user($certificate['student_id'])->row_array();

        // Retrieve student details using $student_row
        $student = $student_row['first_name'].' '.$student_row['last_name'];
        $student_id = $student_row['student_id'];
        $issued_date = strtotime($course['issued_date']); // Convert issued date to timestamp
        // if (!$issued_date) {
        //     $issued_date = $course['date_added'];
        // }
        $certificate_year = $course['certificate_year'];
        $certificate_id = $course['certificate_id'];

        $instructor = $instructor_row['first_name'].' '.$instructor_row['last_name'];

        // Calculate expiry date by adding certificate_year to the issued_date
        $expiry_date_timestamp = strtotime("+$certificate_year year", $issued_date);

        // Calculate the current timestamp
        $current_timestamp = time();

        // Calculate the expiry date in d/m/Y format or "Expired" text
        if ($expiry_date_timestamp < $current_timestamp) {
            $expiry_text = "Expired";
        } else {
            $expiry_text = date('d/m/Y', $expiry_date_timestamp);
        }

        // Retrieve the profile image URL from the user's row using the user model function
        $profile_image_url = $this->user_model->get_user_image_url($certificate['student_id']);

        // Other template replacements as before
        $certificate_template = str_replace("..\..\uploads/certificates/template.jpg", "..\uploads/certificates/template.jpg", remove_js(htmlspecialchars_decode(get_settings('certificate-text-positons'))));
        $certificate_template = str_replace("{date}", date('d/m/Y', $issued_date), $certificate_template); // Add "Issued Date" text
        $certificate_template = str_replace("{expiry_date}", $expiry_text, $certificate_template); // Add expiry date or "Expired"
        $certificate_template = str_replace("{student}", $student, $certificate_template);
        $certificate_template = str_replace("{course}", $course['title'], $certificate_template);
        $certificate_template = str_replace("{certificate_id}", $certificate_id, $certificate_template);
     // $certificate_template = str_replace("{student_id}", 'Student ID ' . ucfirst($student_id), $certificate_template);
        $certificate_template = str_replace("{student_id}", ucfirst($student_id), $certificate_template);
        $certificate_template = str_replace("{certificate_year}", ($expiry_text == "Expired" ? "Expired" : date('d/m/Y', $expiry_date_timestamp)), $certificate_template); // Add expiry date or "Expired"

        // Include the profile image if it's not empty
        if (!empty($profile_image_url)) {
            $certificate_template = str_replace("{image}", '<img src="' . $profile_image_url . '" alt="Profile Image" width="145px" height="185px">', $certificate_template);
        } else {
            // Provide a default image URL
            $default_image_url = 'http://localhost/uploads/user_image/placeholder.png';
            $certificate_template = str_replace("{image}", '<img src="' . $default_image_url . '" alt="Profile Image" width="65px" height="65px">', $certificate_template);
        }

        echo $certificate_template;

    ?>

    </div>
    
    <!--<div class="" style="width: 100%; margin-top: 20px; text-align: center;">
        <a class="download" download><?php echo site_phrase(''); ?></a>
    </div>-->

    <br/>
    
    <script type="text/javascript">
        $(document).ready(function(){
            $('.qrCode').html('<img src="<?php echo base_url(); ?>/uploads/qrcode/qr_code.png" width="100%">');
        
            html2canvas(document.querySelector("#capture"),
                {
                    allowTaint: true,
                    width: '750',
                },
                ).then(canvas => {
                    document.querySelector("#capture").appendChild(canvas);
                    $("canvas").hide();

                    setTimeout(function(){
                        var canvas = document.querySelector("canvas");

                        var dataUrl    = canvas.toDataURL("png");

                        $('.download').attr('href', dataUrl);
                    }, 1000);
                }
            );
        });
    </script>

</body>
</html>
