<?php
class Home_model extends CI_Model

{
    public function getUserByEmail($email) {
        $query = $this->db->get_where('users', ['email' => $email]);
        return $query->row(); // Return a single row if found, otherwise null
    }

    public function insertUserAndImage($email) {
        $dateAdded = strtotime($this->input->post('date_added')); // Convert to UNIX timestamp
    
        $data = [
            'email' => $email,
            'image' => $email, // Use the email as the image path
            'date_added' => $dateAdded, // Insert UNIX timestamp
            'password' => '7c4a8d09ca3762af61e59520943dc26494f8941b', // Default password
            'role_id' => 2, // Default role_id
            'status' => 1, // Default status
            // 'payment_status' => 0, // Default payment_status
            'payment_keys' => '[]', // Default payment_keys as JSON string "[]"
        ];
        $this->db->insert('users', $data);
    }
    
    public function process() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['excel_file'])) {
            $uploadedFile = $_FILES['excel_file']['tmp_name'];
            $reader = new IOFactory(); // Create an instance of IOFactory
    
            try {
                $spreadsheet = $reader->load($uploadedFile);
                $sheet = $spreadsheet->getActiveSheet();
    
                foreach ($sheet->getColumnIterator('A') as $column) {
                    foreach ($column->getCellIterator() as $cell) {
                        $email = $cell->getValue();
    
                        // Check if the email already exists in the users table
                        $this->load->model('Home_model'); // Load the Home_model
                        $existingUser = $this->home_model->getUserByEmail($email);
    
                        if (!$existingUser) {
                            // Insert user data and image
                            $imagePath = $email; // Update with the image path
    
                            // Load the User_model to access insertUserAndImage method
                            $this->load->model('Home_model');
                            $this->home_model->insertUserAndImage($email, $imagePath);
                        }
                    }
                }
    
                echo 'Excel data processed successfully!';
            } catch (\Exception $e) {
                echo 'Error: ' . $e->getMessage();
            }
        } else {
            echo 'No file uploaded!';
        }
    }
}
