<?php
defined('BASEPATH') or exit('No direct script access allowed');

//error_reporting(E_ALL);
//ini_set('display_errors', 1);

use PhpOffice\PhpSpreadsheet\IOFactory;

class Upload extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->database(); // Load the database library
        $this->load->model('Home_model'); // Load the Home_model
        $this->load->library('session');
        /*cache control*/
        $this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
        $this->output->set_header('Pragma: no-cache');

        $this->user_model->check_session_data('admin');

        ini_set('memory_limit', '128M');
    }

    public function index() {
        $this->load->view('upload'); // Load the upload.php view
    }

    public function upload_process() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['excel_file'])) {
            $uploadedFile = $_FILES['excel_file']['tmp_name'];
            $reader = IOFactory::createReader('Xlsx');
    
            try {
                $spreadsheet = $reader->load($uploadedFile);
                $worksheet = $spreadsheet->getActiveSheet();
    
                $selectedCourseId = $this->input->post('course_id');
                $expiryDate = strtotime($this->input->post('expiry_date')); // Convert to UNIX timestamp
                $dateAdded = strtotime($this->input->post('date_added')); // Convert to UNIX timestamp
    
                foreach ($worksheet->getColumnIterator('A') as $column) {
                    foreach ($column->getCellIterator() as $cell) {
                        $email = $cell->getValue();

                        if ($email) {
                            // Check if the email exists in the database
                            $existingUser = $this->Home_model->getUserByEmail($email);
        
                            if ($existingUser) {
                                foreach ($selectedCourseId as $courseId) {
                                    // Check if the user-course combination already exists
                                    $existingEnrollment = $this->db->get_where('enrol', ['user_id' => $existingUser->id, 'course_id' => $courseId])->row();
        
                                    if (!$existingEnrollment) {
                                        $enrollmentData = [
                                            'user_id' => $existingUser->id,
                                            'course_id' => $courseId,
                                            'expiry_date' => $expiryDate, // Insert UNIX timestamp
                                            'date_added' => $dateAdded, // Insert UNIX timestamp
                                        ];
                                        $this->db->insert('enrol', $enrollmentData);
                                    }
                                }
                            } else {
                                $imagePath = ''; // Update with the image path
                                $this->Home_model->insertUserAndImage($email, $imagePath);
        
                                $newUser = $this->Home_model->getUserByEmail($email);
        
                                foreach ($selectedCourseId as $courseId) {
                                    // Check if the user-course combination already exists
                                    $existingEnrollment = $this->db->get_where('enrol', ['user_id' => $newUser->id, 'course_id' => $courseId])->row();
        
                                    if (!$existingEnrollment) {
                                        $enrollmentData = [
                                            'user_id' => $newUser->id,
                                            'course_id' => $courseId,
                                            'expiry_date' => $expiryDate, // Insert UNIX timestamp
                                            'date_added' => $dateAdded, // Insert UNIX timestamp
                                        ];
                                        $this->db->insert('enrol', $enrollmentData);
                                    }
                                }
                            }
                        }
                    }
                }
    
                echo 'Excel data processed successfully!';
            } catch (\Exception $e) {
                echo 'Error: ' . $e->getMessage();
            }
        } else {
            echo 'No file uploaded!';
        }
    }
    
    
    
}