<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\FlexApi\V1;

use Twilio\Options;
use Twilio\Values;

abstract class InsightsConversationalAiReportInsightsOptions
{
    /**
     * @param int $maxRows Maximum number of rows to return
     * @param string $reportId The type of report insights required to fetch.Like gauge,channel-metrics,queue-metrics
     * @param string $granularity The time period for which report insights is needed
     * @param \DateTime $includeDate A reference date that should be included in the returned period
     * @return FetchInsightsConversationalAiReportInsightsOptions Options builder
     */
    public static function fetch(
        
        int $maxRows = Values::INT_NONE,
        string $reportId = Values::NONE,
        string $granularity = Values::NONE,
        \DateTime $includeDate = null

    ): FetchInsightsConversationalAiReportInsightsOptions
    {
        return new FetchInsightsConversationalAiReportInsightsOptions(
            $maxRows,
            $reportId,
            $granularity,
            $includeDate
        );
    }

}

class FetchInsightsConversationalAiReportInsightsOptions extends Options
    {
    /**
     * @param int $maxRows Maximum number of rows to return
     * @param string $reportId The type of report insights required to fetch.Like gauge,channel-metrics,queue-metrics
     * @param string $granularity The time period for which report insights is needed
     * @param \DateTime $includeDate A reference date that should be included in the returned period
     */
    public function __construct(
        
        int $maxRows = Values::INT_NONE,
        string $reportId = Values::NONE,
        string $granularity = Values::NONE,
        \DateTime $includeDate = null

    ) {
        $this->options['maxRows'] = $maxRows;
        $this->options['reportId'] = $reportId;
        $this->options['granularity'] = $granularity;
        $this->options['includeDate'] = $includeDate;
    }

    /**
     * Maximum number of rows to return
     *
     * @param int $maxRows Maximum number of rows to return
     * @return $this Fluent Builder
     */
    public function setMaxRows(int $maxRows): self
    {
        $this->options['maxRows'] = $maxRows;
        return $this;
    }

    /**
     * The type of report insights required to fetch.Like gauge,channel-metrics,queue-metrics
     *
     * @param string $reportId The type of report insights required to fetch.Like gauge,channel-metrics,queue-metrics
     * @return $this Fluent Builder
     */
    public function setReportId(string $reportId): self
    {
        $this->options['reportId'] = $reportId;
        return $this;
    }

    /**
     * The time period for which report insights is needed
     *
     * @param string $granularity The time period for which report insights is needed
     * @return $this Fluent Builder
     */
    public function setGranularity(string $granularity): self
    {
        $this->options['granularity'] = $granularity;
        return $this;
    }

    /**
     * A reference date that should be included in the returned period
     *
     * @param \DateTime $includeDate A reference date that should be included in the returned period
     * @return $this Fluent Builder
     */
    public function setIncludeDate(\DateTime $includeDate): self
    {
        $this->options['includeDate'] = $includeDate;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.FetchInsightsConversationalAiReportInsightsOptions ' . $options . ']';
    }
}

