<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="section-header">
            <h1><?php echo e(trans('admin/main.blog_categories')); ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(getAdminPanelUrl()); ?>"><?php echo e(trans('admin/main.dashboard')); ?></a></div>
                <div class="breadcrumb-item"><?php echo e(trans('admin/main.blog_categories')); ?></div>
            </div>
        </div>

        <div class="section-body">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">

                            <ul class="nav nav-pills" id="myTab3" role="tablist">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin_blog_categories')): ?>
                                    <?php if(!empty($blogCategories)): ?>
                                        <li class="nav-item">
                                            <a class="nav-link <?php echo e((!empty($errors) and $errors->has('title')) ? '' : 'active'); ?>" id="categories-tab" data-toggle="tab" href="#categories" role="tab" aria-controls="categories" aria-selected="true"><?php echo e(trans('admin/main.categories')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin_blog_categories_create')): ?>
                                    <li class="nav-item">
                                        <a class="nav-link <?php echo e(((!empty($errors) and $errors->has('title')) or !empty($editCategory)) ? 'active' : ''); ?>" id="newCategory-tab" data-toggle="tab" href="#newCategory" role="tab" aria-controls="newCategory" aria-selected="true"><?php echo e(trans('admin/main.create_category')); ?></a>
                                    </li>
                                <?php endif; ?>
                            </ul>

                            <div class="tab-content" id="myTabContent2">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin_blog_categories')): ?>
                                    <?php if(!empty($blogCategories)): ?>
                                        <div class="tab-pane mt-3 fade <?php echo e((!empty($errors) and $errors->has('title')) ? '' : 'active show'); ?>" id="categories" role="tabpanel" aria-labelledby="categories-tab">
                                            <div class="table-responsive">
                                                <table class="table table-striped font-14">
                                                    <tr>
                                                        <th class="text-left"><?php echo e(trans('admin/main.title')); ?></th>
                                                        <th class="text-center"><?php echo e(trans('admin/main.posts')); ?></th>
                                                        <th><?php echo e(trans('admin/main.action')); ?></th>
                                                    </tr>

                                                    <?php $__currentLoopData = $blogCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td class="text-left"><?php echo e($category->title); ?></td>
                                                            <td class="text-center"><?php echo e($category->blog_count); ?></td>
                                                            <td>
                                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin_edit_trending_categories')): ?>
                                                                    <a href="<?php echo e(getAdminPanelUrl()); ?>/blog/categories/<?php echo e($category->id); ?>/edit" class="btn-transparent text-primary" data-toggle="tooltip" data-placement="top" title="<?php echo e(trans('admin/main.edit')); ?>">
                                                                        <i class="fa fa-edit"></i>
                                                                    </a>
                                                                <?php endif; ?>
                                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin_delete_trending_categories')): ?>
                                                                    <?php echo $__env->make('admin.includes.delete_button',['url' => getAdminPanelUrl('/blog/categories/'. $category->id .'/delete'), 'btnClass' => ''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </table>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin_blog_categories_create')): ?>
                                    <div class="tab-pane mt-3 fade <?php echo e(((!empty($errors) and $errors->has('title')) or !empty($editCategory)) ? 'active show' : ''); ?>" id="newCategory" role="tabpanel" aria-labelledby="newCategory-tab">
                                        <div class="row">
                                            <div class="col-12 col-md-6">
                                                <form action="<?php echo e(getAdminPanelUrl()); ?>/blog/categories/<?php echo e(!empty($editCategory) ? $editCategory->id.'/update' : 'store'); ?>" method="post">
                                                    <?php echo e(csrf_field()); ?>


                                                    <?php if(!empty(getGeneralSettings('content_translate')) and !empty($userLanguages)): ?>
                                                        <div class="form-group">
                                                            <label class="input-label"><?php echo e(trans('auth.language')); ?></label>
                                                            <select name="locale" class="form-control <?php echo e(!empty($editCategory) ? 'js-edit-content-locale' : ''); ?>">
                                                                <?php $__currentLoopData = $userLanguages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($lang); ?>" <?php if(mb_strtolower(request()->get('locale', app()->getLocale())) == mb_strtolower($lang)): ?> selected <?php endif; ?>><?php echo e($language); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                            <?php $__errorArgs = ['locale'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <div class="invalid-feedback">
                                                                <?php echo e($message); ?>

                                                            </div>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>
                                                    <?php else: ?>
                                                        <input type="hidden" name="locale" value="<?php echo e(getDefaultLocale()); ?>">
                                                    <?php endif; ?>

                                                    <div class="form-group">
                                                        <label><?php echo e(trans('/admin/main.title')); ?></label>
                                                        <input type="text" name="title"
                                                               class="form-control  <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                               value="<?php echo e(!empty($editCategory) ? $editCategory->title : ''); ?>"
                                                               placeholder="<?php echo e(trans('admin/main.choose_title')); ?>"/>
                                                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback">
                                                            <?php echo e($message); ?>

                                                        </div>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>

                                                    <button type="submit" class="btn btn-success"><?php echo e(trans('admin/main.save_change')); ?></button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts_bottom'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/neftenergies/public_html/docroot.neft.sa/resources/views/admin/blog/categories.blade.php ENDPATH**/ ?>