<?php $__env->startPush('styles_top'); ?>
    <link rel="stylesheet" href="/assets/default/vendors/daterangepicker/daterangepicker.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <section class="mt-25">
        <h2 class="section-title"><?php echo e(trans('quiz.filter_certificates')); ?></h2>

        <div class="panel-section-card py-20 px-25 mt-20">
            <form action="" method="get" class="row">
                <div class="col-12 col-lg-6">
                    <div class="row">
                        <div class="col-12 col-md-6">
                            <div class="form-group">
                                <label class="input-label"><?php echo e(trans('public.from')); ?></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="dateInputGroupPrepend">
                                            <i data-feather="calendar" width="18" height="18" class="text-white"></i>
                                        </span>
                                    </div>
                                    <input type="text" name="from" autocomplete="off" class="form-control <?php if(!empty(request()->get('from'))): ?> datepicker <?php else: ?> datefilter <?php endif; ?>" value="<?php echo e(request()->get('from','')); ?>" aria-describedby="dateInputGroupPrepend"/>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-6">
                            <div class="form-group">
                                <label class="input-label"><?php echo e(trans('public.to')); ?></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="dateInputGroupPrepend">
                                            <i data-feather="calendar" width="18" height="18" class="text-white"></i>
                                        </span>
                                    </div>
                                    <input type="text" name="to" autocomplete="off" class="form-control <?php if(!empty(request()->get('to'))): ?> datepicker <?php else: ?> datefilter <?php endif; ?>" value="<?php echo e(request()->get('to','')); ?>" aria-describedby="dateInputGroupPrepend"/>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-lg-4">
                    <div class="form-group">
                        <label class="input-label"><?php echo e(trans('product.course')); ?></label>
                        <select name="course_name" class="form-control">
                            <option value="all"><?php echo e(trans('webinars.all_courses')); ?></option>
                            <?php $__currentLoopData = $certifications->pluck('course_name')->unique()->filter(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($courseName); ?>" <?php if(request()->get('course_name','') == $courseName): ?> selected <?php endif; ?>><?php echo e($courseName); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="col-12 col-lg-2 d-flex align-items-center justify-content-end">
                    <button type="submit" class="btn btn-sm btn-primary w-100 mt-2"><?php echo e(trans('public.show_results')); ?></button>
                </div>
            </form>
        </div>
    </section>

    <section class="mt-35">
        <div class="d-flex align-items-start align-items-md-center justify-content-between flex-column flex-md-row">
            <h2 class="section-title"><?php echo e(trans('quiz.my_certificates')); ?></h2>
        </div>

        <?php if(!empty($certifications) and count($certifications)): ?>
            <div class="panel-section-card py-20 px-25 mt-20">
                <div class="row">
                    <div class="col-12 ">
                        <div class="table-responsive">
                            <table class="table text-center custom-table">
                                <thead>
                                <tr>
                                    <th><?php echo e(trans('cart.item')); ?></th>
                                    <th class="text-center"><?php echo e(trans('public.certificate_id')); ?></th>
                                    <th class="text-center">Issue Date</th>
                                    <th class="text-center">Expiry Date</th>
                                    <th class="text-center"><?php echo e(trans('public.status')); ?></th>
                                </tr>
                                </thead>
                                <tbody>

                                <?php $__currentLoopData = $certifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $certification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="text-left">
                                            <span class="d-block text-dark-blue font-weight-500">
                                                <?php echo e($certification->course_name ?? 'N/A'); ?>

                                            </span>
                                        </td>

                                        <td class="text-center">
                                            <?php echo e($certification->neft_certificate_number ?? 'N/A'); ?>

                                        </td>

                                        <td class="text-center">
                                            <span class="text-dark-blue font-weight-500">
                                                <?php if(!empty($certification->issue_date)): ?>
                                                    <?php echo e(\Carbon\Carbon::parse($certification->issue_date)->format('j M Y')); ?>

                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </span>
                                        </td>

                                        <td class="text-center">
                                            <span class="text-dark-blue font-weight-500">
                                                <?php if(!empty($certification->expiration_date)): ?>
                                                    <?php echo e(\Carbon\Carbon::parse($certification->expiration_date)->format('j M Y')); ?>

                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </span>
                                        </td>

                                        <td class="text-center">
                                            <?php
                                                $status = 'Active';
                                                $statusClass = 'success';
                                                if (!empty($certification->expiration_date)) {
                                                    $expiryDate = \Carbon\Carbon::parse($certification->expiration_date);
                                                    if ($expiryDate->isPast()) {
                                                        $status = 'Expired';
                                                        $statusClass = 'danger';
                                                    } elseif ($expiryDate->diffInDays(now()) <= 30) {
                                                        $status = 'Expiring Soon';
                                                        $statusClass = 'warning';
                                                    }
                                                }
                                            ?>
                                            <span class="badge badge-<?php echo e($statusClass); ?>"><?php echo e($status); ?></span>
                                        </td>

                                        <td class="text-center">
                                            <!-- Actions removed - display only -->
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <?php echo $__env->make(getTemplate() . '.includes.no-result',[
                'file_name' => 'cert.png',
                'title' => trans('quiz.my_certificates_no_result'),
                'hint' => nl2br(trans('quiz.my_certificates_no_result_hint')),
            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts_bottom'); ?>
    <script src="/assets/default/vendors/daterangepicker/daterangepicker.min.js"></script>
    <script src="/assets/default/js/panel/certificates.min.js"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make(getTemplate() .'.panel.layouts.panel_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/neftenergies/public_html/docroot.neft.sa/resources/views/web/default/panel/certificates/certificates.blade.php ENDPATH**/ ?>