<?php
/**
 * Temporary Migration Runner
 * WARNING: DELETE THIS FILE AFTER RUNNING THE MIGRATION
 * This file should NEVER be accessible in production for security reasons
 */

// Add basic authentication to prevent unauthorized access
$auth_password = 'YOUR_SECURE_PASSWORD_HERE'; // CHANGE THIS!

if (!isset($_GET['password']) || $_GET['password'] !== $auth_password) {
    die('Unauthorized access');
}

// Change to the Laravel root directory
chdir(__DIR__);

// Load Laravel
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';

// Boot the application
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// Run the migration
echo "<pre>";
echo "Running migrations...\n\n";

try {
    $exitCode = Artisan::call('migrate', [
        '--force' => true, // Force run in production
    ]);
    
    echo Artisan::output();
    
    if ($exitCode === 0) {
        echo "\n✅ Migration completed successfully!\n";
    } else {
        echo "\n❌ Migration failed with exit code: {$exitCode}\n";
    }
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo $e->getTraceAsString();
}

echo "\n\n⚠️ IMPORTANT: DELETE THIS FILE (run_migration.php) IMMEDIATELY FOR SECURITY!\n";
echo "</pre>";

