@extends(getTemplate() .'.panel.layouts.panel_layout')

@push('styles_top')
    <link rel="stylesheet" href="/assets/default/vendors/daterangepicker/daterangepicker.min.css">
@endpush

@section('content')
    <section class="mt-25">
        <h2 class="section-title">{{ trans('quiz.filter_certificates') }}</h2>

        <div class="panel-section-card py-20 px-25 mt-20">
            <form action="" method="get" class="row">
                <div class="col-12 col-lg-6">
                    <div class="row">
                        <div class="col-12 col-md-6">
                            <div class="form-group">
                                <label class="input-label">{{ trans('public.from') }}</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="dateInputGroupPrepend">
                                            <i data-feather="calendar" width="18" height="18" class="text-white"></i>
                                        </span>
                                    </div>
                                    <input type="text" name="from" autocomplete="off" class="form-control @if(!empty(request()->get('from'))) datepicker @else datefilter @endif" value="{{ request()->get('from','') }}" aria-describedby="dateInputGroupPrepend"/>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-6">
                            <div class="form-group">
                                <label class="input-label">{{ trans('public.to') }}</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="dateInputGroupPrepend">
                                            <i data-feather="calendar" width="18" height="18" class="text-white"></i>
                                        </span>
                                    </div>
                                    <input type="text" name="to" autocomplete="off" class="form-control @if(!empty(request()->get('to'))) datepicker @else datefilter @endif" value="{{ request()->get('to','') }}" aria-describedby="dateInputGroupPrepend"/>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-lg-4">
                    <div class="form-group">
                        <label class="input-label">{{ trans('product.course') }}</label>
                        <select name="course_name" class="form-control">
                            <option value="all">{{ trans('webinars.all_courses') }}</option>
                            @foreach($certifications->pluck('course_name')->unique()->filter() as $courseName)
                                <option value="{{ $courseName }}" @if(request()->get('course_name','') == $courseName) selected @endif>{{ $courseName }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-12 col-lg-2 d-flex align-items-center justify-content-end">
                    <button type="submit" class="btn btn-sm btn-primary w-100 mt-2">{{ trans('public.show_results') }}</button>
                </div>
            </form>
        </div>
    </section>

    <section class="mt-35">
        <div class="d-flex align-items-start align-items-md-center justify-content-between flex-column flex-md-row">
            <h2 class="section-title">{{ trans('quiz.my_certificates') }}</h2>
        </div>

        @if(!empty($certifications) and count($certifications))
            <div class="panel-section-card py-20 px-25 mt-20">
                <div class="row">
                    <div class="col-12 ">
                        <div class="table-responsive">
                            <table class="table text-center custom-table">
                                <thead>
                                <tr>
                                    <th>{{ trans('cart.item') }}</th>
                                    <th class="text-center">{{ trans('public.certificate_id') }}</th>
                                    <th class="text-center">Issue Date</th>
                                    <th class="text-center">Expiry Date</th>
                                    <th class="text-center">{{ trans('public.status') }}</th>
                                </tr>
                                </thead>
                                <tbody>

                                @foreach($certifications as $certification)
                                    <tr>
                                        <td class="text-left">
                                            <span class="d-block text-dark-blue font-weight-500">
                                                {{ $certification->course_name ?? 'N/A' }}
                                            </span>
                                        </td>

                                        <td class="text-center">
                                            {{ $certification->neft_certificate_number ?? 'N/A' }}
                                        </td>

                                        <td class="text-center">
                                            <span class="text-dark-blue font-weight-500">
                                                @if(!empty($certification->issue_date))
                                                    {{ \Carbon\Carbon::parse($certification->issue_date)->format('j M Y') }}
                                                @else
                                                    N/A
                                                @endif
                                            </span>
                                        </td>

                                        <td class="text-center">
                                            <span class="text-dark-blue font-weight-500">
                                                @if(!empty($certification->expiration_date))
                                                    {{ \Carbon\Carbon::parse($certification->expiration_date)->format('j M Y') }}
                                                @else
                                                    N/A
                                                @endif
                                            </span>
                                        </td>

                                        <td class="text-center">
                                            @php
                                                $status = 'Active';
                                                $statusClass = 'success';
                                                if (!empty($certification->expiration_date)) {
                                                    $expiryDate = \Carbon\Carbon::parse($certification->expiration_date);
                                                    if ($expiryDate->isPast()) {
                                                        $status = 'Expired';
                                                        $statusClass = 'danger';
                                                    } elseif ($expiryDate->diffInDays(now()) <= 30) {
                                                        $status = 'Expiring Soon';
                                                        $statusClass = 'warning';
                                                    }
                                                }
                                            @endphp
                                            <span class="badge badge-{{ $statusClass }}">{{ $status }}</span>
                                        </td>

                                        <td class="text-center">
                                            <!-- Actions removed - display only -->
                                        </td>
                                    </tr>
                                @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        @else
            @include(getTemplate() . '.includes.no-result',[
                'file_name' => 'cert.png',
                'title' => trans('quiz.my_certificates_no_result'),
                'hint' => nl2br(trans('quiz.my_certificates_no_result_hint')),
            ])
        @endif
    </section>

@endsection

@push('scripts_bottom')
    <script src="/assets/default/vendors/daterangepicker/daterangepicker.min.js"></script>
    <script src="/assets/default/js/panel/certificates.min.js"></script>
@endpush
