-- ============================================
-- CERTIFICATION PERFORMANCE OPTIMIZATION
-- Run these queries one by one in phpMyAdmin
-- ============================================

-- STEP 1: Check if indexes exist
-- ============================================
SHOW INDEXES FROM certifications;
-- You should see idx_certifications_id_no, idx_certifications_govt_id, etc.


-- STEP 2: Check table statistics
-- ============================================
SELECT 
    COUNT(*) as total_certifications,
    COUNT(DISTINCT id_no) as unique_id_numbers,
    COUNT(DISTINCT govt_id) as unique_govt_ids,
    AVG(LENGTH(CONCAT_WS('', neft_certificate_number, name, company, course_name))) as avg_row_size
FROM certifications;
-- This shows how much data you're working with


-- STEP 3: Check if indexes are being used (TEST WITH YOUR STUDENT_ID)
-- ============================================
-- Replace 'YOUR_STUDENT_ID_HERE' with an actual student_id from your database
EXPLAIN SELECT Id, neft_certificate_number, name, id_no, govt_id, 
               company, course_name, actual_date, issue_date, 
               expiration_date, template
FROM certifications 
WHERE id_no = 'YOUR_STUDENT_ID_HERE' 
   OR govt_id = 'YOUR_STUDENT_ID_HERE'
ORDER BY Id DESC;
-- Look for "Using index" in the Extra column
-- If you see "Using filesort" or "Using temporary", indexes aren't helping


-- STEP 4: If indexes exist but query is still slow, try this alternative approach
-- ============================================
-- This uses UNION which can be faster than OR for indexed columns
-- Replace 'YOUR_STUDENT_ID_HERE' with actual student_id
EXPLAIN (
    SELECT Id, neft_certificate_number, name, id_no, govt_id, 
           company, course_name, actual_date, issue_date, 
           expiration_date, template
    FROM certifications 
    WHERE id_no = 'YOUR_STUDENT_ID_HERE'
    
    UNION
    
    SELECT Id, neft_certificate_number, name, id_no, govt_id, 
           company, course_name, actual_date, issue_date, 
           expiration_date, template
    FROM certifications 
    WHERE govt_id = 'YOUR_STUDENT_ID_HERE'
) ORDER BY Id DESC;


-- STEP 5: Check for any NULL values that might slow down indexes
-- ============================================
SELECT 
    COUNT(*) as total_rows,
    SUM(CASE WHEN id_no IS NULL THEN 1 ELSE 0 END) as null_id_no,
    SUM(CASE WHEN govt_id IS NULL THEN 1 ELSE 0 END) as null_govt_id,
    SUM(CASE WHEN id_no IS NULL AND govt_id IS NULL THEN 1 ELSE 0 END) as both_null
FROM certifications;


-- STEP 6: Analyze and optimize the table (IMPORTANT!)
-- ============================================
ANALYZE TABLE certifications;
OPTIMIZE TABLE certifications;
-- This rebuilds indexes and updates statistics
-- It might take a few seconds but is safe to run


-- STEP 7: Check slow query log (if enabled)
-- ============================================
SHOW VARIABLES LIKE 'slow_query_log';
SHOW VARIABLES LIKE 'long_query_time';


-- STEP 8: If still slow, create a covering index (all columns in one index)
-- ============================================
-- WARNING: Only run this if the above optimizations don't work
-- This creates a large index but includes all needed columns
CREATE INDEX idx_certifications_covering 
ON certifications(id_no, govt_id, Id, neft_certificate_number, name, 
                  company, course_name, actual_date, issue_date, 
                  expiration_date, template);
-- This is a "covering index" - query can be answered from index alone without table lookup


-- ============================================
-- VERIFICATION: Test actual query speed
-- ============================================
SET profiling = 1;

-- Run your actual query (replace YOUR_STUDENT_ID_HERE)
SELECT Id, neft_certificate_number, name, id_no, govt_id, 
       company, course_name, actual_date, issue_date, 
       expiration_date, template
FROM certifications 
WHERE id_no = 'YOUR_STUDENT_ID_HERE' 
   OR govt_id = 'YOUR_STUDENT_ID_HERE'
ORDER BY Id DESC;

-- See how long it took
SHOW PROFILES;

-- Get detailed breakdown
SHOW PROFILE FOR QUERY 1;

SET profiling = 0;

