<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIndexesToCertificationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('certifications', function (Blueprint $table) {
            // Add index on Id for primary key lookups (if not already indexed)
            // Note: Id is already the primary key so it has an index
            
            // Add index on id_no for faster lookups
            $table->index('id_no', 'idx_certifications_id_no');
            
            // Add index on govt_id for faster lookups
            $table->index('govt_id', 'idx_certifications_govt_id');
            
            // Add composite index for the common query pattern (Id with id_no and govt_id)
            // This will significantly speed up the WHERE Id = ? AND (id_no = ? OR govt_id = ?) query
            $table->index(['Id', 'id_no'], 'idx_certifications_id_id_no');
            $table->index(['Id', 'govt_id'], 'idx_certifications_id_govt_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('certifications', function (Blueprint $table) {
            $table->dropIndex('idx_certifications_id_no');
            $table->dropIndex('idx_certifications_govt_id');
            $table->dropIndex('idx_certifications_id_id_no');
            $table->dropIndex('idx_certifications_id_govt_id');
        });
    }
}

