-- ============================================
-- Check if indexes exist on certifications table
-- ============================================
SHOW INDEXES FROM certifications;

-- ============================================
-- Check table size and row count
-- ============================================
SELECT 
    COUNT(*) as total_rows,
    COUNT(DISTINCT id_no) as unique_id_no,
    COUNT(DISTINCT govt_id) as unique_govt_id
FROM certifications;

-- ============================================
-- Test query performance with EXPLAIN
-- Replace 'YOUR_STUDENT_ID' with an actual student_id
-- ============================================
EXPLAIN SELECT * FROM certifications 
WHERE id_no = 'YOUR_STUDENT_ID' 
   OR govt_id = 'YOUR_STUDENT_ID'
ORDER BY Id DESC;

-- ============================================
-- Better query with UNION (faster than OR)
-- ============================================
EXPLAIN (
    SELECT * FROM certifications WHERE id_no = 'YOUR_STUDENT_ID'
    UNION
    SELECT * FROM certifications WHERE govt_id = 'YOUR_STUDENT_ID'
)
ORDER BY Id DESC;

