-- ============================================
-- Add Indexes to Certifications Table
-- Run this in cPanel phpMyAdmin
-- ============================================

-- Add index on id_no for faster lookups
CREATE INDEX idx_certifications_id_no ON certifications(id_no);

-- Add index on govt_id for faster lookups
CREATE INDEX idx_certifications_govt_id ON certifications(govt_id);

-- Add composite index for the common query pattern (Id with id_no)
CREATE INDEX idx_certifications_id_id_no ON certifications(Id, id_no);

-- Add composite index for the alternative lookup path (Id with govt_id)
CREATE INDEX idx_certifications_id_govt_id ON certifications(Id, govt_id);

-- ============================================
-- Verification Query (Optional - Run after creating indexes)
-- This will show you all indexes on the certifications table
-- ============================================
SHOW INDEXES FROM certifications;

