-- ============================================
-- QUICK FIX - Run this in phpMyAdmin NOW
-- ============================================

-- Step 1: Ensure indexes exist (won't fail if they already exist)
-- ============================================
CREATE INDEX IF NOT EXISTS idx_certifications_id_no ON certifications(id_no);
CREATE INDEX IF NOT EXISTS idx_certifications_govt_id ON certifications(govt_id);
CREATE INDEX IF NOT EXISTS idx_certifications_id_id_no ON certifications(Id, id_no);
CREATE INDEX IF NOT EXISTS idx_certifications_id_govt_id ON certifications(Id, govt_id);

-- Step 2: CRITICAL - Rebuild indexes and update statistics
-- ============================================
ANALYZE TABLE certifications;
OPTIMIZE TABLE certifications;

-- Step 3: Verify indexes were created
-- ============================================
SHOW INDEXES FROM certifications WHERE Key_name LIKE 'idx_certifications%';

-- ============================================
-- If still slow after this, run Step 4
-- ============================================

-- Step 4: Create a COVERING INDEX (Run only if still slow)
-- This allows MySQL to answer queries entirely from the index
-- ============================================
-- Uncomment the line below if needed:
-- CREATE INDEX idx_certifications_covering ON certifications(id_no, govt_id, Id, neft_certificate_number, name, company, course_name, actual_date, issue_date, expiration_date, template);

